--
-- Copyright  2010. Autodesk, Inc. All rights reserved.
--
rollout DYNresourceMan ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCiniPath
  local LOCmapPath
  local LOCiniFile
  local LOCobjectMenu
  local LOClensSizes = #()
  local LOCaspectRatio = 0.0
  local LOCiniTreeKeyItem
  local LOCresourceKitMode = 1
  local LOCallowDnSelection = true

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNcopyINIfileToAnotherResourceKit FUNiniFile FUNresourceFolder1 FUNresourceFolder2 FUNmode =
  (
    local LOCtargetObjectPath = ""
    if FUNmode == 1 then LOCtargetObjectPath = DYNcountryPath                     -- Using Country Resource Kit
    if FUNmode == 2 then LOCtargetObjectPath = rootNode.DYNrootNodeStore.string02 -- Using Project Resource Kit
    if FUNmode == 3 then LOCtargetObjectPath = DYNINIprivateKitPath               -- Using Private Resource Kit

    local LOCnewFilePath = DYNFUNmakeNewFileNameUnique (LOCtargetObjectPath + FUNresourceFolder1 + (filenameFromPath FUNiniFile)) ".ini"

    if querybox (DYNuiResourcesQueries[77] + "\n\n" + LOCnewFilePath) title:DYNuiResourcesTitlebars[2] then
    (
      --- First, Copy Resources Used Within File
      local LOCsuccessA  = true
      local LOCsuccessB  = true
      local LOCobjParams = DYNFUNobjectINIparams (getFilenameFile FUNiniFile) (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) DYNresourceMan.LOCresourceKitMode

      --- copy max file and preview file
      if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 1 then
      (
        if doesFileExist LOCobjParams[5] then (LOCsuccessA = DYNFUNcopyFile LOCobjParams[5] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[5])) (subString (getFilenameType LOCobjParams[5]) 2 -1) false)
        if doesFileExist LOCobjParams[7] then (LOCsuccessB = DYNFUNcopyFile LOCobjParams[7] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[7])) (subString (getFilenameType LOCobjParams[7]) 2 -1) false)
      )

      --- copy max file and preview file
      if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 2 then
      (
        if doesFileExist LOCobjParams[5] then (LOCsuccessA = DYNFUNcopyFile LOCobjParams[5] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[5])) (subString (getFilenameType LOCobjParams[5]) 2 -1) false)
        if doesFileExist LOCobjParams[7] then (LOCsuccessB = DYNFUNcopyFile LOCobjParams[7] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[7])) (subString (getFilenameType LOCobjParams[7]) 2 -1) false)
      )

      --- copy diffuse map and opacity map
      if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 3 then
      (
        if doesFileExist LOCobjParams[7] then (LOCsuccessA = DYNFUNcopyFile LOCobjParams[7] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[7])) (subString (getFilenameType LOCobjParams[7]) 2 -1) false)
        if doesFileExist LOCobjParams[8] then (LOCsuccessB = DYNFUNcopyFile LOCobjParams[8] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[8])) (subString (getFilenameType LOCobjParams[8]) 2 -1) false)
      )

      --- copy diffuse map and opacity map
      if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 4 then
      (
        if doesFileExist LOCobjParams[7] then (LOCsuccessA = DYNFUNcopyFile LOCobjParams[7] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[7])) (subString (getFilenameType LOCobjParams[7]) 2 -1) false)
        if doesFileExist LOCobjParams[8] then (LOCsuccessB = DYNFUNcopyFile LOCobjParams[8] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[8])) (subString (getFilenameType LOCobjParams[8]) 2 -1) false)
      )

      --- Now copy INI file
      local LOCsuccessC = DYNFUNcopyFile FUNiniFile LOCnewFilePath "INI" true

      --- Update Panel
      DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
    )
  )

  fn DYNFUNmoveINIfileToAnotherResourceKit FUNiniFile FUNresourceFolder1 FUNresourceFolder2 FUNmode =
  (
    local LOCtargetObjectPath = ""
    if FUNmode == 1 then LOCtargetObjectPath = DYNcountryPath                     -- Using Country Resource Kit
    if FUNmode == 2 then LOCtargetObjectPath = rootNode.DYNrootNodeStore.string02 -- Using Project Resource Kit
    if FUNmode == 3 then LOCtargetObjectPath = DYNINIprivateKitPath               -- Using Private Resource Kit

    local LOCnewFilePath = DYNFUNmakeNewFileNameUnique (LOCtargetObjectPath + FUNresourceFolder1 + (filenameFromPath FUNiniFile)) ".ini"

    if querybox (DYNuiResourcesQueries[78] + "\n\n" + LOCnewFilePath) title:DYNuiResourcesTitlebars[2] then
    (
      --- First, Copy Resources Used Within File
      local LOCsuccessA  = true
      local LOCsuccessB  = true
      local LOCobjParams = DYNFUNobjectINIparams (getFilenameFile FUNiniFile) (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) DYNresourceMan.LOCresourceKitMode

      --- copy max file and preview file
      if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 1 then
      (
        if doesFileExist LOCobjParams[5] then (LOCsuccessA = DYNFUNcopyFile LOCobjParams[5] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[5])) (subString (getFilenameType LOCobjParams[5]) 2 -1) false)
        if doesFileExist LOCobjParams[7] then (LOCsuccessB = DYNFUNcopyFile LOCobjParams[7] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[7])) (subString (getFilenameType LOCobjParams[7]) 2 -1) false)
      )

      --- copy max file and preview file
      if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 2 then
      (
        if doesFileExist LOCobjParams[5] then (LOCsuccessA = DYNFUNcopyFile LOCobjParams[5] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[5])) (subString (getFilenameType LOCobjParams[5]) 2 -1) false)
        if doesFileExist LOCobjParams[7] then (LOCsuccessB = DYNFUNcopyFile LOCobjParams[7] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[7])) (subString (getFilenameType LOCobjParams[7]) 2 -1) false)
      )

      --- copy diffuse map and opacity map
      if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 3 then
      (
        if doesFileExist LOCobjParams[7] then (LOCsuccessA = DYNFUNcopyFile LOCobjParams[7] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[7])) (subString (getFilenameType LOCobjParams[7]) 2 -1) false)
        if doesFileExist LOCobjParams[8] then (LOCsuccessB = DYNFUNcopyFile LOCobjParams[8] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[8])) (subString (getFilenameType LOCobjParams[8]) 2 -1) false)
      )

      --- copy diffuse map and opacity map
      if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 4 then
      (
        if doesFileExist LOCobjParams[7] then (LOCsuccessA = DYNFUNcopyFile LOCobjParams[7] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[7])) (subString (getFilenameType LOCobjParams[7]) 2 -1) false)
        if doesFileExist LOCobjParams[8] then (LOCsuccessB = DYNFUNcopyFile LOCobjParams[8] (LOCtargetObjectPath + FUNresourceFolder2 + (filenameFromPath LOCobjParams[8])) (subString (getFilenameType LOCobjParams[8]) 2 -1) false)
      )

      --- Now copy INI file
      local LOCsuccessC = DYNFUNrenameFile FUNiniFile LOCnewFilePath "INI" true

      --- Update Panel
      DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
      DYNresourceMan.DYNFUNchangeCategory (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) ""
    )
  )


  fn DYNFUNdisplayBitmapAttribs FUNmapFile FUNtext1 FUNtext2 FUNtext3 =
  (
    local LOCbitmap = try (openBitmap FUNmapFile) catch ()

    if LOCbitmap != undefined then
    (
      FUNtext1.text = DYNuiResourcesLabels[602] + " " + (LOCbitmap.width  as string) + " x " + (LOCbitmap.height as string) + " " + DYNuiResourcesUnitsDistance[12]
      FUNtext2.text = DYNuiResourcesLabels[383] + " " + ((getFileSize FUNmapFile) as string) + " " + DYNuiResourcesUnitsDistance[13]
      FUNtext3.text = DYNuiResourcesLabels[603] + " " + (if LOCbitmap.hasAlpha then DYNuiResourcesLabels[149] else DYNuiResourcesLabels[150])
      close LOCbitmap
    )
    else
    (
      FUNtext1.text = ""
      FUNtext2.text = ""
      FUNtext3.text = ""
    )
  )

  --- Function to display a right-click menu over object ini file tree
  fn DYNFUNobjectMenu =
  (
    DYNresourceMan.LOCobjectMenu = undefined

    local LOCexe = "rcmenu LOCobjectMenu\n"
    LOCexe += "(\n"
    LOCexe += "  --- Local Variables\n"
    LOCexe += "  local LOCresourceFolder1 = \"\"\n"
    LOCexe += "  local LOCresourceFolder2 = \"\"\n"
    LOCexe += "\n"
    LOCexe += "  --- Menu Items\n"
    LOCexe += "  menuItem  MNDYNexpand          checked:false\n"
    LOCexe += "  menuItem  MNDYNcollapse        checked:false\n"
    LOCexe += "  separator MNDYNseparate3\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[8] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNmoveToCountry checked:false enabled:false\n"
    LOCexe += "    menuItem  MNDYNmoveToProject checked:false enabled:false\n"
    LOCexe += "    menuItem  MNDYNmoveToPrivate checked:false enabled:false\n"
    LOCexe += "  )\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[9] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNcopyToCountry checked:false enabled:false\n"
    LOCexe += "    menuItem  MNDYNcopyToProject checked:false enabled:false\n"
    LOCexe += "    menuItem  MNDYNcopyToPrivate checked:false enabled:false\n"
    LOCexe += "  )\n"
    LOCexe += "  separator MNDYNseparate2\n"
    LOCexe += "  menuItem  MNDYNcopyINI         checked:false enabled:false\n"
    LOCexe += "  separator MNDYNseparate4\n"
    LOCexe += "  menuItem  MNDYNdeleteINI       checked:false enabled:false\n"
    LOCexe += "  menuItem  MNDYNrenameINI       checked:false enabled:false\n"
    LOCexe += "\n"
    LOCexe += "  on LOCobjectMenu open do\n"
    LOCexe += "  (\n"
    LOCexe += "    MNDYNexpand.text        = DYNuiResourcesMenus[3]\n"
    LOCexe += "    MNDYNcollapse.text      = DYNuiResourcesMenus[4]\n"
    LOCexe += "    MNDYNmoveToCountry.text = DYNuiResourcesMenus[47]\n"
    LOCexe += "    MNDYNcopyToCountry.text = DYNuiResourcesMenus[47]\n"
    LOCexe += "    MNDYNmoveToProject.text = DYNuiResourcesMenus[48]\n"
    LOCexe += "    MNDYNcopyToProject.text = DYNuiResourcesMenus[48]\n"
    LOCexe += "    MNDYNmoveToPrivate.text = DYNuiResourcesMenus[49]\n"
    LOCexe += "    MNDYNcopyToPrivate.text = DYNuiResourcesMenus[49]\n"
    LOCexe += "    MNDYNcopyINI.text       = DYNuiResourcesMenus[34]\n"
    LOCexe += "    MNDYNdeleteINI.text     = DYNuiResourcesMenus[10]\n"
    LOCexe += "    MNDYNrenameINI.text     = DYNuiResourcesMenus[7]\n"
    LOCexe += "\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 1 then LOCresourceFolder1 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameVehicles + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 2 then LOCresourceFolder1 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameFurniture + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 3 then LOCresourceFolder1 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameTrees + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 4 then LOCresourceFolder1 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameSigns + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 5 then LOCresourceFolder1 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameCameras + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 6 then LOCresourceFolder1 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNamePrimitives + DYNfolderSeperator\n"
    LOCexe += "\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 1 then LOCresourceFolder2 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameVehicles + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 2 then LOCresourceFolder2 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameFurniture + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 3 then LOCresourceFolder2 = DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameTreeMaps + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 4 then LOCresourceFolder2 = DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameSignMaps + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 5 then LOCresourceFolder2 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameCameras + DYNfolderSeperator\n"
    LOCexe += "    if (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) == 6 then LOCresourceFolder2 = DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNamePrimitives + DYNfolderSeperator\n"
    LOCexe += "\n"
    LOCexe += "    local LOCcountryKitItemsEnabled = DYNresourceMan.LOCresourceKitMode != 1\n"
    LOCexe += "    local LOCprojectKitItemsEnabled = DYNresourceMan.LOCresourceKitMode != 2 and DYNINIprojectKit != \"0\" and (DYNFUNdoesFolderExist (rootNode.DYNrootNodeStore.string02 + LOCresourceFolder1))\n"
    LOCexe += "    local LOCprivateKitItemsEnabled = DYNresourceMan.LOCresourceKitMode != 3 and DYNINIprivateKit == \"1\" and (DYNFUNdoesFolderExist (DYNINIprivateKitPath + LOCresourceFolder1))\n"
    LOCexe += "\n"
    LOCexe += "    if (subString DYNresourceMan.DNDYNiniFileTree.selectedNode.name 1 1) != \"!\" then\n"
    LOCexe += "    (\n"
    LOCexe += "      MNDYNcopyINI.enabled       = false\n"
    LOCexe += "      MNDYNdeleteINI.enabled     = false\n"
    LOCexe += "      MNDYNrenameINI.enabled     = false\n"
    LOCexe += "      MNDYNmoveToCountry.enabled = false\n"
    LOCexe += "      MNDYNcopyToCountry.enabled = false\n"
    LOCexe += "      MNDYNmoveToProject.enabled = false\n"
    LOCexe += "      MNDYNcopyToProject.enabled = false\n"
    LOCexe += "      MNDYNmoveToPrivate.enabled = false\n"
    LOCexe += "      MNDYNcopyToPrivate.enabled = false\n"
    LOCexe += "    )\n"
    LOCexe += "    else\n"
    LOCexe += "    (\n"
    LOCexe += "      MNDYNcopyINI.enabled       = true\n"
    LOCexe += "      MNDYNdeleteINI.enabled     = true\n"
    LOCexe += "      MNDYNrenameINI.enabled     = true\n"
    LOCexe += "      MNDYNmoveToCountry.enabled = LOCcountryKitItemsEnabled\n"
    LOCexe += "      MNDYNcopyToCountry.enabled = LOCcountryKitItemsEnabled\n"
    LOCexe += "      MNDYNmoveToProject.enabled = LOCprojectKitItemsEnabled\n"
    LOCexe += "      MNDYNcopyToProject.enabled = LOCprojectKitItemsEnabled\n"
    LOCexe += "      MNDYNmoveToPrivate.enabled = LOCprivateKitItemsEnabled\n"
    LOCexe += "      MNDYNcopyToPrivate.enabled = LOCprivateKitItemsEnabled\n"
    LOCexe += "    )\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNexpand picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    DYNresourceMan.DNDYNiniFileTree.nodes.item[0].expand()\n"
    LOCexe += "    for i = 1 to DYNresourceMan.DNDYNiniFileTree.nodes.item[0].nodes.count do\n"
    LOCexe += "    (\n"
    LOCexe += "      DYNresourceMan.DNDYNiniFileTree.nodes.item[0].nodes.item[i-1].expand()\n"
    LOCexe += "    )\n"
    LOCexe += "    DYNresourceMan.DNDYNiniFileTree.selectedNode.ensureVisible()\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNcollapse picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCsaveNode = DYNresourceMan.DNDYNiniFileTree.selectedNode\n"
    LOCexe += "    for i = 1 to DYNresourceMan.DNDYNiniFileTree.nodes.item[0].nodes.count do\n"
    LOCexe += "    (\n"
    LOCexe += "      DYNresourceMan.DNDYNiniFileTree.nodes.item[0].nodes.item[i-1].collapse()\n"
    LOCexe += "    )\n"
    LOCexe += "    DYNresourceMan.DNDYNiniFileTree.selectedNode = DYNresourceMan.DNDYNiniFileTree.nodes.item[0]\n"
    LOCexe += "    DYNresourceMan.DYNFUNselectINI()\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNcopyToCountry picked do (DYNresourceMan.DYNFUNcopyINIfileToAnotherResourceKit DYNresourceMan.LOCiniFile LOCresourceFolder1 LOCresourceFolder2 1)\n"
    LOCexe += "  on MNDYNmoveToCountry picked do (DYNresourceMan.DYNFUNmoveINIfileToAnotherResourceKit DYNresourceMan.LOCiniFile LOCresourceFolder1 LOCresourceFolder2 1)\n"
    LOCexe += "  on MNDYNcopyToProject picked do (DYNresourceMan.DYNFUNcopyINIfileToAnotherResourceKit DYNresourceMan.LOCiniFile LOCresourceFolder1 LOCresourceFolder2 2)\n"
    LOCexe += "  on MNDYNmoveToProject picked do (DYNresourceMan.DYNFUNmoveINIfileToAnotherResourceKit DYNresourceMan.LOCiniFile LOCresourceFolder1 LOCresourceFolder2 2)\n"
    LOCexe += "  on MNDYNcopyToPrivate picked do (DYNresourceMan.DYNFUNcopyINIfileToAnotherResourceKit DYNresourceMan.LOCiniFile LOCresourceFolder1 LOCresourceFolder2 3)\n"
    LOCexe += "  on MNDYNmoveToPrivate picked do (DYNresourceMan.DYNFUNmoveINIfileToAnotherResourceKit DYNresourceMan.LOCiniFile LOCresourceFolder1 LOCresourceFolder2 3)\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNcopyINI picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCnewFilePath = DYNFUNmakeNewFileNameUnique DYNresourceMan.LOCiniFile \".ini\"\n"
    LOCexe += "    local LOCnewFileName = DYNFUNdisplayEditText DYNuiResourcesTitlebars[28] DYNuiResourcesLabels[325] (getFilenameFile LOCnewFilePath)\n"
    LOCexe += "\n"
    LOCexe += "    if LOCnewFileName != undefined and LOCnewFileName != \"\" then\n"
    LOCexe += "    (\n"
    LOCexe += "      if (findString LOCnewFileName \",\") == undefined then\n"
    LOCexe += "      (\n"
    LOCexe += "        LOCnewFilePath       = (getFilenamePath LOCnewFilePath) + (getFilenameFile LOCnewFileName) + \".ini\"\n"
    LOCexe += "        if not (DoesfileExist LOCnewFilePath) then\n"
    LOCexe += "        (\n"
    LOCexe += "          DYNFUNiniCopyFile DYNresourceMan.LOCiniFile LOCnewFilePath DYNresourceMan.LOCresourceKitMode\n"
    LOCexe += "          DYNresourceMan.DYNFUNchangeCategory (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) LOCnewFileName\n"
    LOCexe += "        )\n"
    LOCexe += "      )\n"
    LOCexe += "      else (messagebox (DYNuiResourcesErrorsWarnings[88]) title:DYNuiResourcesTitlebars[1])\n"
    LOCexe += "    )\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNdeleteINI picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    if (queryBox (DYNuiResourcesQueries[26]) title:DYNuiResourcesTitlebars[2]) then (DYNresourceMan.DYNFUNremoveConfigINIFile DYNresourceMan.LOCiniFile)\n"
    LOCexe += "    setFocus DYNresourceMan.DNDYNiniFileTree\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNrenameINI picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    local LOCnewFileName = DYNFUNdisplayEditText DYNuiResourcesTitlebars[28] DYNuiResourcesLabels[325] (getFilenameFile DYNresourceMan.LOCiniFile)\n"
    LOCexe += "    if LOCnewFileName != undefined and LOCnewFileName != \"\" then\n"
    LOCexe += "    (\n"
    LOCexe += "      if (findString LOCnewFileName \",\") == undefined then\n"
    LOCexe += "      (\n"
    LOCexe += "        local LOCnewFilePath = (getFilenamePath DYNresourceMan.LOCiniFile) + (getFilenameFile LOCnewFileName) + \".ini\"\n"
    LOCexe += "        if (DoesfileExist LOCnewFilePath) == false then\n"
    LOCexe += "        (\n"
    LOCexe += "          DYNFUNiniRenameFile DYNresourceMan.LOCiniFile LOCnewFilePath LOCresourceKitMode\n"
    LOCexe += "          DYNresourceMan.DYNFUNchangeCategory (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) (getFilenameFile LOCnewFilePath)\n"
    LOCexe += "        )\n"
    LOCexe += "        else\n"
    LOCexe += "        (\n"
    LOCexe += "          if (getFilenameFile LOCnewFileName) != DYNresourceMan.DNDYNiniFileTree.selectedNode.text then (messagebox (DYNuiResourcesErrorsWarnings[89]) title:DYNuiResourcesTitlebars[1])\n"
    LOCexe += "        )\n"
    LOCexe += "      )\n"
    LOCexe += "      else\n"
    LOCexe += "      (\n"
    LOCexe += "        messagebox (DYNuiResourcesErrorsWarnings[88]) title:DYNuiResourcesTitlebars[1]\n"
    LOCexe += "      )\n"
    LOCexe += "    )\n"
    LOCexe += "  )\n"
    LOCexe += ")\n"

    DYNresourceMan.LOCobjectMenu = Execute LOCexe

    registerRightClickMenu DYNresourceMan.LOCobjectMenu
  )

  fn DYNFUNupdateStatusPanel =
  (
    local LOCmatch = false
    if DYNresourceMan.DNDYNiniFileTree.selectedNode != undefined then
    (
      if subString DYNresourceMan.DNDYNiniFileTree.selectedNode.name 1 1 == "!" then
      (
        local LOCselectedIniFile = DYNresourceMan.DNDYNiniFileTree.selectedNode.text + ".ini"
        DYNresourceMan.dnStatus.panels.item[0].text  = LOCselectedIniFile
        DYNresourceMan.dnStatus.panels.item[1].text  = DYNuiResourcesLvColumns[54] + ": " + (DYNFUNconvertGUPdate (DYNFUNgetFileModifyTime   (DYNresourceMan.LOCiniPath + LOCselectedIniFile) true))
        DYNresourceMan.dnStatus.panels.item[2].text  = DYNuiResourcesLabels[41]    + " " + (DYNFUNconvertGUPdate (DYNFUNgetFileCreationTime (DYNresourceMan.LOCiniPath + LOCselectedIniFile) true))
        LOCmatch = true
      )
    )

    if not LOCmatch then
    (
      DYNresourceMan.dnStatus.panels.item[0].text  = ""
      DYNresourceMan.dnStatus.panels.item[1].text  = ""
      DYNresourceMan.dnStatus.panels.item[2].text  = ""
    )
  )

  --- Function to remove an Object INI File
  fn DYNFUNremoveConfigINIFile FUNfile =
  (
    local LOCrtnParam   = false
    local LOCpreviousNode = DYNresourceMan.DNDYNiniFileTree.selectedNode.prevNode
    if LOCpreviousNode != undefined then LOCpreviousNode = DYNresourceMan.DNDYNiniFileTree.selectedNode.prevNode

    if doesFileExist FUNfile then (LOCrtnParam  = deleteFile FUNfile)

    if LOCrtnParam then
    (
      DYNFUNiniRemoveFile FUNfile DYNresourceMan.LOCresourceKitMode

      DYNFUNdisplayINIobjFileArrays (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) DYNresourceMan DYNresourceMan.LOCresourceKitMode
      if LOCpreviousNode != undefined then
      (
        DYNresourceMan.DNDYNiniFileTree.selectedNode = LOCpreviousNode
        LOCpreviousNode.ensureVisible()
      )

      DYNresourceMan.DYNFUNselectINI()
    )
    else
    (
      messageBox (DYNuiResourcesErrorsWarnings[38]) title:DYNuiResourcesTitlebars[1]
    )

    LOCrtnParam -- return value
  )

  fn DYNFUNsetAndVerifyINIvalue FUNfile FUNsection FUNparamName FUNnewParamValue =
  (
    local LOCrtnParam = ""

    --- Set Value in buffers (doesn't update file itself)
    DYNFUNiniSetValue FUNfile FUNsection FUNparamName FUNnewParamValue DYNresourceMan.LOCresourceKitMode

    --- Update Status Bar with filename and date modified/created
    DYNresourceMan.DYNFUNupdateStatusPanel()

    --- Verify that AX buffers and file content is identical
    local LOCverifyVal1 = DYNFUNiniGetValue FUNfile FUNsection FUNparamName DYNresourceMan.LOCresourceKitMode
    local LOCverifyVal2 = getINIsetting FUNfile FUNsection FUNparamName
    if (DYNFUNlowerCase LOCverifyVal1) == (DYNFUNlowerCase LOCverifyVal2) then
    (
      LOCrtnParam = LOCverifyVal2
    )
    else (messageBox (DYNuiResourcesErrorsWarnings[90]) title:DYNuiResourcesTitlebars[1])

    LOCrtnParam -- return value
  )

  fn DYNFUNchangeSourceFile FUNiniPath =
  (
    local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) DYNresourceMan.LOCresourceKitMode
    local LOCfileExtn = getFilenameType LOCtmpArray[5]; if LOCfileExtn == "" then LOCfileExtn = ".max"
    local LOCfilename = FUNiniPath + "*" + LOCfileExtn
    local LOCmax      = DYNFUNcopyFileToResourceKitPath LOCfileName DYNuiResourcesTitlebars[51] DYNuiResourcesFileTypes[12] DYNresourceMan.LOCresourceKitMode

    if (try ((getfiles (FUNiniPath + (filenameFromPath LOCmax))).count) catch (0)) == 0 then LOCmax = undefined

    if LOCmax != undefined then
    (
      DYNresourceMan.LBDYNiniSetting07.text = "Source = " + (DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Object" "Source" (filenameFromPath LOCmax))
    )
    DYNresourceMan.DYNFUNselectINI()
  )

  fn DYNFUNchangeDiffuse FUNmapPath =
  (
    local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) DYNresourceMan.LOCresourceKitMode
    local LOCfileExtn = getFilenameType LOCtmpArray[7]; if LOCfileExtn == "" then LOCfileExtn = ".png"
    local LOCfilename = FUNmapPath + "*" + LOCfileExtn

    local LOCdiff = DYNFUNcopyFileToResourceKitPath LOCfileName DYNuiResourcesTitlebars[48] DYNimageTypes DYNresourceMan.LOCresourceKitMode
    if (try ((getfiles (FUNmapPath + (filenameFromPath LOCdiff))).count) catch (0)) == 0 then LOCdiff = undefined
    if LOCdiff != undefined then
    (
      DYNresourceMan.BMDYNdiffuse.bitmap = DYNFUNrenderBitMap 196 151 LOCdiff
      DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCdiff DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
      DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Maps" "Diffuse" (filenameFromPath LOCdiff)
      local LOCmatDiffuse = try (openBitmap LOCdiff) catch ()
      if LOCmatDiffuse != undefined then
      (
        DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Width"  ((LOCmatDiffuse.width  / 100.0) as string)
        DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Height" ((LOCmatDiffuse.height / 100.0) as string)
        close LOCmatDiffuse
      )
      DYNresourceMan.DYNFUNselectINI()

      --- Check to see whether bitmap has alpha channel. If it has, ask if want to duplicate to opacity map
      local LOCtmpBitmap = try (openBitmap LOCdiff) catch ()
      if LOCtmpBitmap != undefined then
      (
        if LOCtmpBitmap.hasAlpha then
        (
          if (queryBox (DYNuiResourcesQueries[76]) title:DYNuiResourcesTitlebars[3]) then
          (
            local LOCopac = LOCdiff
            DYNresourceMan.BMDYNopacity.bitmap = DYNFUNrenderBitMap 196 151 LOCopac
            DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCopac DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
            DYNresourceMan.LBDYNiniSetting07.text = "Opacity = " + DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Maps" "Opacity" (filenameFromPath LOCopac)
          )
        )
        close LOCtmpBitmap
      )
    )
  )

  fn DYNFUNchangeOpacity FUNmapPath =
  (
    local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) DYNresourceMan.LOCresourceKitMode
    local LOCfileExtn = getFilenameType LOCtmpArray[8]; if LOCfileExtn == "" then LOCfileExtn = ".png"
    local LOCfilename = FUNmapPath + "*" + LOCfileExtn

    local LOCopac = DYNFUNcopyFileToResourceKitPath LOCfileName DYNuiResourcesTitlebars[49] DYNimageTypes DYNresourceMan.LOCresourceKitMode
    if (try ((getfiles (FUNmapPath + (filenameFromPath LOCopac))).count) catch (0)) == 0  then LOCopac = undefined
    if LOCopac != undefined then
    (
      DYNresourceMan.BMDYNopacity.bitmap = DYNFUNrenderBitMap 196 151 LOCopac
      DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCopac DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
      DYNresourceMan.LBDYNiniSetting07.text = "Opacity = " + (DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Maps" "Opacity" (filenameFromPath LOCopac))
    )
  )

  fn DYNFUNchangePreview FUNmode =
  (
    local LOCrootObjectPath = ""
    if FUNmode == 1 then LOCrootObjectPath = DYNcountryPath       -- Using Country Resource Kit
    if FUNmode == 2 then LOCrootObjectPath = rootNode.DYNrootNodeStore.string02 -- Using Project Resource Kit
    if FUNmode == 3 then LOCrootObjectPath = DYNINIprivateKitPath -- Using Private Resource Kit

    local LOCfilename = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNamePreviews + DYNfolderSeperator + "*.png"
    local LOCpreview  = DYNFUNcopyFileToResourceKitPath LOCfileName DYNuiResourcesTitlebars[50] DYNimageTypes DYNresourceMan.LOCresourceKitMode
    if (try ((getfiles (LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNamePreviews + DYNfolderSeperator + (filenameFromPath LOCpreview))).count) catch (0)) == 0  then LOCpreview = undefined
    if LOCpreview != undefined then
    (
      DYNresourceMan.BMDYNopacity.bitmap = DYNFUNrenderBitMap 196 151 LOCpreview
      DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCpreview DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
      DYNresourceMan.LBDYNiniSetting09.text = "Preview = " + (DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Object" "Preview" (filenameFromPath LOCpreview))
    )

  )

  --- Function called when panel is first opened
  fn DYNFUNopenPanel FUNcategory FUNselectedINIfile =
  (
    DYNresourceMan.dnTabCtrl.enabled = true
    DYNresourceMan.dnTabCtrl.selectedIndex = FUNcategory - 1
    DYNresourceMan.DYNFUNchangeCategory (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1) FUNselectedINIfile
  )

  fn DYNFUNselectINI =
  (
    local LOCfileFound = false
    local LOCcol = ((colorMan.getColor #window) as color) * 255
    DYNresourceMan.DYNFUNupdateStatusPanel()

    if DYNresourceMan.DNDYNiniFileTree.selectedNode != undefined then
    (
      if subString DYNresourceMan.DNDYNiniFileTree.selectedNode.name 1 1 == "!" then
      (
        local LOCloadSwitch = false
        local LOCcategory = (DYNresourceMan.dntabCtrl.selectedTab.TabIndex + 1)

        LOCfileFound = true

        DYNresourceMan.LOCiniFile = DYNresourceMan.LOCiniPath + DYNresourceMan.DNDYNiniFileTree.selectedNode.text + ".ini"
        if LOCcategory == 1 then
        (
          DYNresourceMan.CBDYNxFall.enabled = false; DYNresourceMan.CBDYNxFall.checked = false; DYNresourceMan.CBDYNxFall.pos = [2898,130]
          local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) 1 DYNresourceMan.LOCresourceKitMode
          DYNresourceMan.LBDYNiniSetting01.text = "[Parameters]"         ; DYNresourceMan.LBDYNiniSetting01.pos.x = 555
          DYNresourceMan.LBDYNiniSetting02.text = "Length = "            ; DYNresourceMan.LBDYNiniSetting02.pos.x = 565 ; DYNresourceMan.SPDYNspinner01.pos = [880,121]  ; DYNresourceMan.SPDYNspinner01.range = [0,9999,LOCtmpArray[2]]
          DYNresourceMan.LBDYNiniSetting03.text = "Width = "             ; DYNresourceMan.LBDYNiniSetting03.pos.x = 565 ; DYNresourceMan.SPDYNspinner02.pos = [880,142]  ; DYNresourceMan.SPDYNspinner02.range = [0,9999,LOCtmpArray[3]]
          DYNresourceMan.LBDYNiniSetting04.text = "Height = "            ; DYNresourceMan.LBDYNiniSetting04.pos.x = 565 ; DYNresourceMan.SPDYNspinner03.pos = [880,163]  ; DYNresourceMan.SPDYNspinner03.range = [0,9999,LOCtmpArray[4]]
          DYNresourceMan.LBDYNiniSetting05.text = ""                     ; DYNresourceMan.LBDYNiniSetting05.pos.x = 555 ; DYNresourceMan.SPDYNspinner04.pos = [-880,184] ; DYNresourceMan.SPDYNspinner04.range = [0,0,0]
          DYNresourceMan.LBDYNiniSetting06.text = "[Object]"             ; DYNresourceMan.LBDYNiniSetting06.pos.x = 555 ; DYNresourceMan.SPDYNspinner05.pos = [-880,205] ; DYNresourceMan.SPDYNspinner05.range = [0,0,0]
          DYNresourceMan.LBDYNiniSetting07.text = "Source = "            ; DYNresourceMan.LBDYNiniSetting07.pos.x = 565 ; DYNresourceMan.BUDYNbutton01.pos  = [810,226]
          DYNresourceMan.LBDYNiniSetting08.text = "Proxy = "             ; DYNresourceMan.LBDYNiniSetting08.pos.x = 565
          DYNresourceMan.LBDYNiniSetting09.text = "Preview = "           ; DYNresourceMan.LBDYNiniSetting09.pos.x = 565 ; DYNresourceMan.BUDYNbutton02.pos  = [810,269]
          DYNresourceMan.LBDYNiniSetting10.text = ""                     ; DYNresourceMan.LBDYNiniSetting10.pos.x = 555 ;
          DYNresourceMan.LBDYNiniSetting11.text = "[Group]"              ; DYNresourceMan.LBDYNiniSetting11.pos.x = 555 ;
          DYNresourceMan.LBDYNiniSetting12.text = "Name = "              ; DYNresourceMan.LBDYNiniSetting12.pos.x = 565 ; DYNresourceMan.BUDYNbutton03.pos  = [810,332]
          DYNresourceMan.LBDYNiniSetting13.text = ""                     ; DYNresourceMan.LBDYNiniSetting13.pos.x = 555
          DYNresourceMan.LBDYNiniSetting14.text = "[Include]"            ; DYNresourceMan.LBDYNiniSetting14.pos.x = 1555
          DYNresourceMan.LBDYNiniSetting15.text = "Object = "            ; DYNresourceMan.LBDYNiniSetting15.pos.x = 1565 ; DYNresourceMan.BUDYNbutton04.pos  = [1810,395]
          DYNresourceMan.LBDYNiniSetting16.text = "HorizontalOffset = "  ; DYNresourceMan.LBDYNiniSetting16.pos.x = 1565 ; DYNresourceMan.SPDYNspinner06.pos = [1880,416]
          DYNresourceMan.LBDYNiniSetting17.text = "VerticalOffset = "    ; DYNresourceMan.LBDYNiniSetting17.pos.x = 1565 ; DYNresourceMan.SPDYNspinner07.pos = [1880,437]
          DYNresourceMan.LBDYNiniSetting18.text = "ChainageOffset = "    ; DYNresourceMan.LBDYNiniSetting18.pos.x = 1565 ; DYNresourceMan.SPDYNspinner08.pos = [1880,458]
          DYNresourceMan.LBDYNiniSetting19.text = ""
          DYNresourceMan.LBDYNiniSetting20.text = ""
          DYNresourceMan.LBDYNiniSetting21.text = ""
          DYNresourceMan.DDDYNdrop01.selection  = 0 ; DYNresourceMan.DDDYNdrop01.pos  = [-810,226]
          --
          DYNresourceMan.LBDYNiniSetting02.text += LOCtmpArray[2] as string
          DYNresourceMan.LBDYNiniSetting03.text += LOCtmpArray[3] as string
          DYNresourceMan.LBDYNiniSetting04.text += LOCtmpArray[4] as string
          DYNresourceMan.LBDYNiniSetting07.text += filenameFromPath LOCtmpArray[5]
          DYNresourceMan.LBDYNiniSetting08.text += filenameFromPath LOCtmpArray[6]
          DYNresourceMan.LBDYNiniSetting09.text += filenameFromPath LOCtmpArray[7]
          DYNresourceMan.LBDYNiniSetting12.text += LOCtmpArray[9]
          DYNresourceMan.BMDYNdiffuse.bitmap = bitmap 196 151 color:LOCcol

          if LOCtmpArray[7] != "" then
          (
            DYNresourceMan.BMDYNopacity.bitmap = DYNFUNrenderBitMap 196 151 LOCtmpArray[7]
            DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCtmpArray[7] DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )
          else
          (
            DYNresourceMan.BMDYNopacity.bitmap = bitmap 196 151 color:LOCcol
            DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )

          DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
          DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
        )
        if LOCcategory == 2 then
        (
          DYNresourceMan.CBDYNxFall.enabled = false; DYNresourceMan.CBDYNxFall.checked = false; DYNresourceMan.CBDYNxFall.pos = [2898,130]
          local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) 2 DYNresourceMan.LOCresourceKitMode
          DYNresourceMan.LBDYNiniSetting01.text = "[Parameters]"         ; DYNresourceMan.LBDYNiniSetting01.pos.x = 555
          DYNresourceMan.LBDYNiniSetting02.text = "Length = "            ; DYNresourceMan.LBDYNiniSetting02.pos.x = 565 ; DYNresourceMan.SPDYNspinner01.pos = [880,121]  ; DYNresourceMan.SPDYNspinner01.range = [0,9999,LOCtmpArray[2]]
          DYNresourceMan.LBDYNiniSetting03.text = "Width = "             ; DYNresourceMan.LBDYNiniSetting03.pos.x = 565 ; DYNresourceMan.SPDYNspinner02.pos = [880,142]  ; DYNresourceMan.SPDYNspinner02.range = [0,9999,LOCtmpArray[3]]
          DYNresourceMan.LBDYNiniSetting04.text = "Height = "            ; DYNresourceMan.LBDYNiniSetting04.pos.x = 565 ; DYNresourceMan.SPDYNspinner03.pos = [880,163]  ; DYNresourceMan.SPDYNspinner03.range = [0,9999,LOCtmpArray[4]]
          DYNresourceMan.LBDYNiniSetting05.text = ""                     ; DYNresourceMan.LBDYNiniSetting05.pos.x = 555 ; DYNresourceMan.SPDYNspinner04.pos = [-880,184] ; DYNresourceMan.SPDYNspinner04.range = [0,0,0]
          DYNresourceMan.LBDYNiniSetting06.text = "[Object]"             ; DYNresourceMan.LBDYNiniSetting06.pos.x = 555
          DYNresourceMan.LBDYNiniSetting07.text = "Source = "            ; DYNresourceMan.LBDYNiniSetting07.pos.x = 565 ; DYNresourceMan.BUDYNbutton01.pos  = [810,226]
          DYNresourceMan.LBDYNiniSetting08.text = "Proxy = "             ; DYNresourceMan.LBDYNiniSetting08.pos.x = 565
          DYNresourceMan.LBDYNiniSetting09.text = "Preview = "           ; DYNresourceMan.LBDYNiniSetting09.pos.x = 565 ; DYNresourceMan.BUDYNbutton02.pos  = [810,269]
          DYNresourceMan.LBDYNiniSetting10.text = ""                     ; DYNresourceMan.LBDYNiniSetting10.pos.x = 555
          DYNresourceMan.LBDYNiniSetting11.text = "[Placement]"          ; DYNresourceMan.LBDYNiniSetting11.pos.x = 555
          DYNresourceMan.LBDYNiniSetting12.text = "DefaultInterval = "   ; DYNresourceMan.LBDYNiniSetting12.pos.x = 565 ; DYNresourceMan.SPDYNspinner05.pos = [880,332]  ; DYNresourceMan.SPDYNspinner05.range = [1,9999,LOCtmpArray[1]]
          DYNresourceMan.LBDYNiniSetting13.text = ""                     ; DYNresourceMan.LBDYNiniSetting13.pos.x = 555 ;
          DYNresourceMan.LBDYNiniSetting14.text = "[Group]"              ; DYNresourceMan.LBDYNiniSetting14.pos.x = 555 ;
          DYNresourceMan.LBDYNiniSetting15.text = "Name = "              ; DYNresourceMan.LBDYNiniSetting15.pos.x = 565 ; DYNresourceMan.BUDYNbutton03.pos  = [810,395]
          DYNresourceMan.LBDYNiniSetting16.text = ""                     ; DYNresourceMan.LBDYNiniSetting16.pos.x = 555
          DYNresourceMan.LBDYNiniSetting17.text = "[Include]"            ; DYNresourceMan.LBDYNiniSetting17.pos.x = 1555
          DYNresourceMan.LBDYNiniSetting18.text = "Object = "            ; DYNresourceMan.LBDYNiniSetting18.pos.x = 1565 ; DYNresourceMan.BUDYNbutton04.pos  = [1810,458]
          DYNresourceMan.LBDYNiniSetting19.text = "HorizontalOffset = "  ; DYNresourceMan.LBDYNiniSetting19.pos.x = 1565 ; DYNresourceMan.SPDYNspinner06.pos = [1880,479]
          DYNresourceMan.LBDYNiniSetting20.text = "VerticalOffset = "    ; DYNresourceMan.LBDYNiniSetting20.pos.x = 1565 ; DYNresourceMan.SPDYNspinner07.pos = [1880,500]
          DYNresourceMan.LBDYNiniSetting21.text = "ChainageOffset = "    ; DYNresourceMan.LBDYNiniSetting21.pos.x = 1565 ; DYNresourceMan.SPDYNspinner08.pos = [1880,521]
          DYNresourceMan.DDDYNdrop01.selection  = 0; DYNresourceMan.DDDYNdrop01.pos  = [-810,226]
          --
          DYNresourceMan.LBDYNiniSetting02.text += LOCtmpArray[2] as string
          DYNresourceMan.LBDYNiniSetting03.text += LOCtmpArray[3] as string
          DYNresourceMan.LBDYNiniSetting04.text += LOCtmpArray[4] as string
          DYNresourceMan.LBDYNiniSetting07.text += filenameFromPath LOCtmpArray[5]
          DYNresourceMan.LBDYNiniSetting08.text += filenameFromPath LOCtmpArray[6]
          DYNresourceMan.LBDYNiniSetting09.text += filenameFromPath LOCtmpArray[7]
          DYNresourceMan.LBDYNiniSetting12.text += LOCtmpArray[1] as string
          DYNresourceMan.LBDYNiniSetting15.text += LOCtmpArray[9]
          DYNresourceMan.BMDYNdiffuse.bitmap = bitmap 196 151 color:LOCcol

          if LOCtmpArray[7] != "" then
          (
            DYNresourceMan.BMDYNopacity.bitmap = DYNFUNrenderBitMap 196 151 LOCtmpArray[7]
            DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCtmpArray[7] DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )
          else
          (
            DYNresourceMan.BMDYNopacity.bitmap = bitmap 196 151 color:LOCcol
            DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )

          DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
          DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
        )
        if LOCcategory == 3 then
        (
          DYNresourceMan.CBDYNxFall.enabled = true; DYNresourceMan.CBDYNxFall.checked = true; DYNresourceMan.CBDYNxFall.pos = [898,130]
          local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) 3 DYNresourceMan.LOCresourceKitMode
          DYNresourceMan.LBDYNiniSetting01.text = "[Parameters]"         ; DYNresourceMan.LBDYNiniSetting01.pos.x = 555  ; DYNresourceMan.SPDYNspinner05.pos = [-810,100] ; DYNresourceMan.SPDYNspinner05.range = [0,0,0]
          DYNresourceMan.LBDYNiniSetting02.text = "Width = "             ; DYNresourceMan.LBDYNiniSetting02.pos.x = 565  ; DYNresourceMan.SPDYNspinner01.pos = [880,121]  ; DYNresourceMan.SPDYNspinner01.range = [0.1,9999,LOCtmpArray[3]]
          DYNresourceMan.LBDYNiniSetting03.text = "Height = "            ; DYNresourceMan.LBDYNiniSetting03.pos.x = 565  ; DYNresourceMan.SPDYNspinner02.pos = [880,142]  ; DYNresourceMan.SPDYNspinner02.range = [0.1,9999,LOCtmpArray[4]]
          DYNresourceMan.LBDYNiniSetting04.text = ""                     ; DYNresourceMan.LBDYNiniSetting04.pos.x = 555  ; DYNresourceMan.SPDYNspinner03.pos = [-880,163] ; DYNresourceMan.SPDYNspinner03.range = [0,0,0]
          DYNresourceMan.LBDYNiniSetting05.text = "[Maps]"               ; DYNresourceMan.LBDYNiniSetting05.pos.x = 555
          DYNresourceMan.LBDYNiniSetting06.text = "Diffuse = "           ; DYNresourceMan.LBDYNiniSetting06.pos.x = 565  ; DYNresourceMan.BUDYNbutton01.pos  = [810,205]
          DYNresourceMan.LBDYNiniSetting07.text = "Opacity = "           ; DYNresourceMan.LBDYNiniSetting07.pos.x = 565  ; DYNresourceMan.BUDYNbutton02.pos  = [810,226]
          DYNresourceMan.LBDYNiniSetting08.text = ""                     ; DYNresourceMan.LBDYNiniSetting08.pos.x = 555
          DYNresourceMan.LBDYNiniSetting09.text = "[Tree Defaults]"      ; DYNresourceMan.LBDYNiniSetting09.pos.x = 555
          DYNresourceMan.LBDYNiniSetting10.text = "Style = "             ; DYNresourceMan.LBDYNiniSetting10.pos.x = 565  ; DYNresourceMan.DDDYNdrop01.pos    = [810,285]
          DYNresourceMan.LBDYNiniSetting11.text = ""                     ; DYNresourceMan.LBDYNiniSetting11.pos.x = 555
          DYNresourceMan.LBDYNiniSetting12.text = "[Group]"              ; DYNresourceMan.LBDYNiniSetting12.pos.x = 555
          DYNresourceMan.LBDYNiniSetting13.text = "Name = "              ; DYNresourceMan.LBDYNiniSetting13.pos.x = 565  ; DYNresourceMan.BUDYNbutton03.pos  = [810,353]
          DYNresourceMan.LBDYNiniSetting14.text = ""                     ; DYNresourceMan.LBDYNiniSetting14.pos.x = 555
          DYNresourceMan.LBDYNiniSetting15.text = "[Include]"            ; DYNresourceMan.LBDYNiniSetting15.pos.x = 1555 ; DYNresourceMan.SPDYNspinner04.pos = [1880,290]
          DYNresourceMan.LBDYNiniSetting16.text = "Object = "            ; DYNresourceMan.LBDYNiniSetting16.pos.x = 1565 ; DYNresourceMan.BUDYNbutton04.pos  = [1810,416]
          DYNresourceMan.LBDYNiniSetting17.text = "HorizontalOffset = "  ; DYNresourceMan.LBDYNiniSetting17.pos.x = 1565 ; DYNresourceMan.SPDYNspinner06.pos = [1880,437]
          DYNresourceMan.LBDYNiniSetting18.text = "VerticalOffset = "    ; DYNresourceMan.LBDYNiniSetting18.pos.x = 1565 ; DYNresourceMan.SPDYNspinner07.pos = [1880,458]
          DYNresourceMan.LBDYNiniSetting19.text = "ChainageOffset = "    ; DYNresourceMan.LBDYNiniSetting19.pos.x = 1565 ; DYNresourceMan.SPDYNspinner08.pos = [1880,479]
          DYNresourceMan.LBDYNiniSetting20.text = ""
          DYNresourceMan.LBDYNiniSetting21.text = ""
          DYNresourceMan.DDDYNdrop01.selection  = try (LOCtmpArray[1]) catch (0)
          --
          DYNresourceMan.LBDYNiniSetting02.text += LOCtmpArray[3] as string
          DYNresourceMan.LBDYNiniSetting03.text += LOCtmpArray[4] as string
          DYNresourceMan.LBDYNiniSetting06.text += filenameFromPath LOCtmpArray[7]
          DYNresourceMan.LBDYNiniSetting07.text += filenameFromPath LOCtmpArray[8]
          DYNresourceMan.LBDYNiniSetting10.text += LOCtmpArray[1] as string
          DYNresourceMan.LBDYNiniSetting13.text += LOCtmpArray[9]
          --
          if LOCtmpArray[7] != "" then
          (
            DYNresourceMan.BMDYNdiffuse.bitmap = DYNFUNrenderBitMap 196 151 LOCtmpArray[7]
            DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCtmpArray[7] DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
          )
          else
          (
            DYNresourceMan.BMDYNdiffuse.bitmap = bitmap 196 151 color:LOCcol
            DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
          )

          if LOCtmpArray[8] != "" then
          (
            DYNresourceMan.BMDYNopacity.bitmap = DYNFUNrenderBitMap 196 151 LOCtmpArray[8]
            DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCtmpArray[8] DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )
          else
          (
            DYNresourceMan.BMDYNopacity.bitmap = bitmap 196 151 color:LOCcol
            DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )

          DYNresourceMan.LOCaspectRatio = try (LOCtmpArray[3] / LOCtmpArray[4]) catch (0.0)
        )
        if LOCcategory == 4 then
        (
          DYNresourceMan.CBDYNxFall.enabled = true; DYNresourceMan.CBDYNxFall.checked = true; DYNresourceMan.CBDYNxFall.pos = [898,130]
          local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) 4 DYNresourceMan.LOCresourceKitMode
          DYNresourceMan.LBDYNiniSetting01.text = "[Parameters]"         ; DYNresourceMan.LBDYNiniSetting01.pos.x = 555-- ; DYNresourceMan.DDDYNdd01.pos      = [-810,100]
          DYNresourceMan.LBDYNiniSetting02.text = "Width = "             ; DYNresourceMan.LBDYNiniSetting02.pos.x = 565 ; DYNresourceMan.SPDYNspinner01.pos = [880,121]  ; DYNresourceMan.SPDYNspinner01.range = [0.1,9999,LOCtmpArray[3]]
          DYNresourceMan.LBDYNiniSetting03.text = "Height = "            ; DYNresourceMan.LBDYNiniSetting03.pos.x = 565 ; DYNresourceMan.SPDYNspinner02.pos = [880,142]  ; DYNresourceMan.SPDYNspinner02.range = [0.1,9999,LOCtmpArray[4]]
          DYNresourceMan.LBDYNiniSetting04.text = ""                     ; DYNresourceMan.LBDYNiniSetting04.pos.x = 555
          DYNresourceMan.LBDYNiniSetting05.text = "[Maps]"               ; DYNresourceMan.LBDYNiniSetting05.pos.x = 555
          DYNresourceMan.LBDYNiniSetting06.text = "Diffuse = "           ; DYNresourceMan.LBDYNiniSetting06.pos.x = 565 ; DYNresourceMan.BUDYNbutton01.pos  = [810,205]
          DYNresourceMan.LBDYNiniSetting07.text = "Opacity = "           ; DYNresourceMan.LBDYNiniSetting07.pos.x = 565 ; DYNresourceMan.BUDYNbutton02.pos  = [810,226]
          DYNresourceMan.LBDYNiniSetting08.text = ""                     ; DYNresourceMan.LBDYNiniSetting08.pos.x = 555
          DYNresourceMan.LBDYNiniSetting09.text = "[Sign Defaults]"      ; DYNresourceMan.LBDYNiniSetting09.pos.x = 555
          DYNresourceMan.LBDYNiniSetting10.text = "Style = "             ; DYNresourceMan.LBDYNiniSetting10.pos.x = 565 ; DYNresourceMan.DDDYNdrop01.pos    = [810,285]
          DYNresourceMan.LBDYNiniSetting11.text = "Posts = "             ; DYNresourceMan.LBDYNiniSetting11.pos.x = 565 ; DYNresourceMan.SPDYNspinner05.pos = [880,311]  ; DYNresourceMan.SPDYNspinner05.range = [0,6,LOCtmpArray[5]]
          DYNresourceMan.LBDYNiniSetting12.text = "GroundClearance = "   ; DYNresourceMan.LBDYNiniSetting12.pos.x = 565 ; DYNresourceMan.SPDYNspinner03.pos = [880,332]  ; DYNresourceMan.SPDYNspinner03.range = [0,9999,LOCtmpArray[6]]
          DYNresourceMan.LBDYNiniSetting13.text = ""                     ; DYNresourceMan.LBDYNiniSetting13.pos.x = 555
          DYNresourceMan.LBDYNiniSetting14.text = "[Group]"              ; DYNresourceMan.LBDYNiniSetting14.pos.x = 555
          DYNresourceMan.LBDYNiniSetting15.text = "Name = "              ; DYNresourceMan.LBDYNiniSetting15.pos.x = 565 ; DYNresourceMan.BUDYNbutton03.pos  = [810,395]
          DYNresourceMan.LBDYNiniSetting16.text = ""                     ; DYNresourceMan.LBDYNiniSetting16.pos.x = 555
          DYNresourceMan.LBDYNiniSetting17.text = "[Include]"            ; DYNresourceMan.LBDYNiniSetting17.pos.x = 1555 ; DYNresourceMan.SPDYNspinner04.pos = [1880,290]
          DYNresourceMan.LBDYNiniSetting18.text = "Object = "            ; DYNresourceMan.LBDYNiniSetting18.pos.x = 1565 ; DYNresourceMan.BUDYNbutton04.pos  = [1810,458]
          DYNresourceMan.LBDYNiniSetting19.text = "HorizontalOffset = "  ; DYNresourceMan.LBDYNiniSetting19.pos.x = 1565 ; DYNresourceMan.SPDYNspinner06.pos = [1880,479]
          DYNresourceMan.LBDYNiniSetting20.text = "VerticalOffset = "    ; DYNresourceMan.LBDYNiniSetting20.pos.x = 1565 ; DYNresourceMan.SPDYNspinner07.pos = [1880,500]
          DYNresourceMan.LBDYNiniSetting21.text = "ChainageOffset = "    ; DYNresourceMan.LBDYNiniSetting21.pos.x = 1565 ; DYNresourceMan.SPDYNspinner08.pos = [1880,521]
          DYNresourceMan.DDDYNdrop01.selection  = try (LOCtmpArray[1]) catch (0)
          --
          DYNresourceMan.LBDYNiniSetting02.text += LOCtmpArray[3] as string
          DYNresourceMan.LBDYNiniSetting03.text += LOCtmpArray[4] as string
          DYNresourceMan.LBDYNiniSetting06.text += filenameFromPath LOCtmpArray[7]
          DYNresourceMan.LBDYNiniSetting07.text += filenameFromPath LOCtmpArray[8]
          DYNresourceMan.LBDYNiniSetting10.text += LOCtmpArray[1] as string
          DYNresourceMan.LBDYNiniSetting11.text += LOCtmpArray[5] as string
          DYNresourceMan.LBDYNiniSetting12.text += LOCtmpArray[6] as string
          DYNresourceMan.LBDYNiniSetting15.text += LOCtmpArray[9]
          --
          if LOCtmpArray[7] != "" then
          (
            DYNresourceMan.BMDYNdiffuse.bitmap = DYNFUNrenderBitMap 196 151 LOCtmpArray[7]
            DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCtmpArray[7] DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
          )
          else
          (
            DYNresourceMan.BMDYNdiffuse.bitmap = bitmap 196 151 color:LOCcol
            DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
          )

          if LOCtmpArray[8] != "" then
          (
            DYNresourceMan.BMDYNopacity.bitmap = DYNFUNrenderBitMap 196 151 LOCtmpArray[8]
            DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCtmpArray[8] DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )
          else
          (
            DYNresourceMan.BMDYNopacity.bitmap = bitmap 196 151 color:LOCcol
            DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )

          DYNresourceMan.LOCaspectRatio = try (LOCtmpArray[3] / LOCtmpArray[4]) catch (0.0)
        )
        if LOCcategory == 5 then
        (
          DYNresourceMan.CBDYNxFall.enabled = false; DYNresourceMan.CBDYNxFall.checked = false; DYNresourceMan.CBDYNxFall.pos = [2898,151]
          local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) 5 DYNresourceMan.LOCresourceKitMode
          DYNresourceMan.LBDYNiniSetting01.text = "[Parameters]"         ; DYNresourceMan.LBDYNiniSetting01.pos.x = 555 ; DYNresourceMan.SPDYNspinner04.pos = [-880,100] ; DYNresourceMan.SPDYNspinner04.range = [0,0,0]
          DYNresourceMan.LBDYNiniSetting02.text = "Lens = "              ; DYNresourceMan.LBDYNiniSetting02.pos.x = 565 ; DYNresourceMan.DDDYNdrop01.pos    = [810,116]
          DYNresourceMan.LBDYNiniSetting03.text = "EnvironmentNear = "   ; DYNresourceMan.LBDYNiniSetting03.pos.x = 565 ; DYNresourceMan.SPDYNspinner01.pos = [880,142]  ; DYNresourceMan.SPDYNspinner01.range = [0,9990,LOCtmpArray[5]]
          DYNresourceMan.LBDYNiniSetting04.text = "EnvironmentFar = "    ; DYNresourceMan.LBDYNiniSetting04.pos.x = 565 ; DYNresourceMan.SPDYNspinner02.pos = [880,163]  ; DYNresourceMan.SPDYNspinner02.range = [10,9999,LOCtmpArray[6]]
          DYNresourceMan.LBDYNiniSetting05.text = "TargetLength = "      ; DYNresourceMan.LBDYNiniSetting05.pos.x = 565 ; DYNresourceMan.SPDYNspinner05.pos = [880,184]  ; DYNresourceMan.SPDYNspinner05.range = [5,9999,LOCtmpArray[8]]
          DYNresourceMan.LBDYNiniSetting06.text = ""                     ; DYNresourceMan.LBDYNiniSetting06.pos.x = 555
          DYNresourceMan.LBDYNiniSetting07.text = "[Group]"              ; DYNresourceMan.LBDYNiniSetting07.pos.x = 555
          DYNresourceMan.LBDYNiniSetting08.text = "Name = "              ; DYNresourceMan.LBDYNiniSetting08.pos.x = 565 ; DYNresourceMan.BUDYNbutton03.pos  = [810,248]
          DYNresourceMan.LBDYNiniSetting09.text = ""                     ; DYNresourceMan.LBDYNiniSetting09.pos.x = 555
          DYNresourceMan.LBDYNiniSetting10.text = "[Include]"            ; DYNresourceMan.LBDYNiniSetting10.pos.x = 1555 ; DYNresourceMan.BUDYNbutton01.pos  = [1810,121]
          DYNresourceMan.LBDYNiniSetting11.text = "Object = "            ; DYNresourceMan.LBDYNiniSetting11.pos.x = 1565 ; DYNresourceMan.BUDYNbutton04.pos  = [1810,311]
          DYNresourceMan.LBDYNiniSetting12.text = "HorizontalOffset = "  ; DYNresourceMan.LBDYNiniSetting12.pos.x = 1565 ; DYNresourceMan.SPDYNspinner06.pos = [1880,332]
          DYNresourceMan.LBDYNiniSetting13.text = "VerticalOffset = "    ; DYNresourceMan.LBDYNiniSetting13.pos.x = 1565 ; DYNresourceMan.SPDYNspinner07.pos = [1880,353]
          DYNresourceMan.LBDYNiniSetting14.text = "ChainageOffset = "    ; DYNresourceMan.LBDYNiniSetting14.pos.x = 1565 ; DYNresourceMan.SPDYNspinner08.pos = [1880,374]
          DYNresourceMan.LBDYNiniSetting15.text = ""                                                                     ; DYNresourceMan.SPDYNspinner03.pos = [-880,226] ; DYNresourceMan.SPDYNspinner03.range = [0,0,0]
          DYNresourceMan.LBDYNiniSetting16.text = ""                                                                     ; DYNresourceMan.BUDYNbutton02.pos  = [-810,248]
          DYNresourceMan.LBDYNiniSetting17.text = ""
          DYNresourceMan.LBDYNiniSetting18.text = ""
          DYNresourceMan.LBDYNiniSetting19.text = ""
          DYNresourceMan.LBDYNiniSetting20.text = ""
          DYNresourceMan.LBDYNiniSetting21.text = ""
          DYNresourceMan.DDDYNdrop01.selection  = try (LOCtmpArray[1]) catch (0)
          --
          DYNresourceMan.LBDYNiniSetting02.text += LOCtmpArray[1] as string
          DYNresourceMan.LBDYNiniSetting03.text += LOCtmpArray[5] as string
          DYNresourceMan.LBDYNiniSetting04.text += LOCtmpArray[6] as string
          DYNresourceMan.LBDYNiniSetting05.text += LOCtmpArray[8] as string
          DYNresourceMan.LBDYNiniSetting08.text += LOCtmpArray[9]
          --
          DYNresourceMan.BMDYNdiffuse.bitmap = bitmap 196 151 color:LOCcol
          DYNresourceMan.BMDYNopacity.bitmap = bitmap 196 151 color:LOCcol
          DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
          DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
        )
        if LOCcategory == 6 then
        (
          DYNresourceMan.CBDYNxFall.enabled = false; DYNresourceMan.CBDYNxFall.checked = false; DYNresourceMan.CBDYNxFall.pos = [2898,130]
          local LOCtmpArray = DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) 6 DYNresourceMan.LOCresourceKitMode
          DYNresourceMan.LBDYNiniSetting01.text = "[Parameters]"        ; DYNresourceMan.LBDYNiniSetting01.pos.x = 555 ; DYNresourceMan.SPDYNspinner05.pos = [-880,100]  ; DYNresourceMan.SPDYNspinner05.range = [0,0,0]
          DYNresourceMan.LBDYNiniSetting02.text = "Length = "           ; DYNresourceMan.LBDYNiniSetting02.pos.x = 565 ; DYNresourceMan.SPDYNspinner01.pos = [880,121]   ; DYNresourceMan.SPDYNspinner01.range = [0,9999,LOCtmpArray[2]]
          DYNresourceMan.LBDYNiniSetting03.text = "Width = "            ; DYNresourceMan.LBDYNiniSetting03.pos.x = 565 ; DYNresourceMan.SPDYNspinner02.pos = [880,142]   ; DYNresourceMan.SPDYNspinner02.range = [0,9999,LOCtmpArray[3]]
          DYNresourceMan.LBDYNiniSetting04.text = "Height = "           ; DYNresourceMan.LBDYNiniSetting04.pos.x = 565 ; DYNresourceMan.SPDYNspinner03.pos = [880,163]   ; DYNresourceMan.SPDYNspinner03.range = [-9999,9999,LOCtmpArray[4]]
          DYNresourceMan.LBDYNiniSetting05.text = ""                    ; DYNresourceMan.LBDYNiniSetting05.pos.x = 555
          DYNresourceMan.LBDYNiniSetting06.text = "[Object]"            ; DYNresourceMan.LBDYNiniSetting06.pos.x = 555
          DYNresourceMan.LBDYNiniSetting07.text = "Primitive = "        ; DYNresourceMan.LBDYNiniSetting07.pos.x = 565 ; DYNresourceMan.DDDYNdrop01.pos    = [810,221]
          DYNresourceMan.LBDYNiniSetting08.text = "MaterialChannel = "  ; DYNresourceMan.LBDYNiniSetting08.pos.x = 565 ; DYNresourceMan.SPDYNspinner04.pos = [880,248]   ; DYNresourceMan.SPDYNspinner04.range = [1,10,LOCtmpArray[5]]
          DYNresourceMan.LBDYNiniSetting09.text = "Preview = "          ; DYNresourceMan.LBDYNiniSetting09.pos.x = 565 ; DYNresourceMan.BUDYNbutton02.pos  = [810,269]
          DYNresourceMan.LBDYNiniSetting10.text = ""                    ; DYNresourceMan.LBDYNiniSetting10.pos.x = 555
          DYNresourceMan.LBDYNiniSetting11.text = "[Group]"             ; DYNresourceMan.LBDYNiniSetting11.pos.x = 555
          DYNresourceMan.LBDYNiniSetting12.text = "Name = "             ; DYNresourceMan.LBDYNiniSetting12.pos.x = 565 ; DYNresourceMan.BUDYNbutton03.pos  = [810,332]
          DYNresourceMan.LBDYNiniSetting13.text = ""                    ; DYNresourceMan.LBDYNiniSetting13.pos.x = 555
          DYNresourceMan.LBDYNiniSetting14.text = "[Include]"           ; DYNresourceMan.LBDYNiniSetting14.pos.x = 1555 ; DYNresourceMan.BUDYNbutton01.pos  = [1810,226]
          DYNresourceMan.LBDYNiniSetting15.text = "Object = "           ; DYNresourceMan.LBDYNiniSetting15.pos.x = 1565 ; DYNresourceMan.BUDYNbutton04.pos  = [1810,395]
          DYNresourceMan.LBDYNiniSetting16.text = "HorizontalOffset = " ; DYNresourceMan.LBDYNiniSetting16.pos.x = 1565 ; DYNresourceMan.SPDYNspinner06.pos = [1880,416]
          DYNresourceMan.LBDYNiniSetting17.text = "VerticalOffset = "   ; DYNresourceMan.LBDYNiniSetting17.pos.x = 1565 ; DYNresourceMan.SPDYNspinner07.pos = [1880,437]
          DYNresourceMan.LBDYNiniSetting18.text = "ChainageOffset = "   ; DYNresourceMan.LBDYNiniSetting18.pos.x = 1565 ; DYNresourceMan.SPDYNspinner08.pos = [1880,458]
          DYNresourceMan.LBDYNiniSetting19.text = ""
          DYNresourceMan.LBDYNiniSetting20.text = ""
          DYNresourceMan.LBDYNiniSetting21.text = ""
          DYNresourceMan.DDDYNdrop01.selection  = findItem DYNprimitiveTypes LOCtmpArray[8]
          --
          DYNresourceMan.LBDYNiniSetting02.text += LOCtmpArray[2] as string
          DYNresourceMan.LBDYNiniSetting03.text += LOCtmpArray[3] as string
          DYNresourceMan.LBDYNiniSetting04.text += LOCtmpArray[4] as string
          DYNresourceMan.LBDYNiniSetting07.text += LOCtmpArray[8]
          DYNresourceMan.LBDYNiniSetting08.text += LOCtmpArray[5] as string
          DYNresourceMan.LBDYNiniSetting09.text += filenameFromPath LOCtmpArray[7]
          DYNresourceMan.LBDYNiniSetting12.text += LOCtmpArray[9]
          --
          DYNresourceMan.BMDYNdiffuse.bitmap   = bitmap 196 151 color:LOCcol

          if LOCtmpArray[7] != "" then
          (
            DYNresourceMan.BMDYNopacity.bitmap = DYNFUNrenderBitMap 196 151 LOCtmpArray[7]
            DYNresourceMan.DYNFUNdisplayBitmapAttribs LOCtmpArray[7] DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )
          else
          (
            DYNresourceMan.BMDYNopacity.bitmap = bitmap 196 151 color:LOCcol
            DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
          )

          DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
          DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
        )

        --- Check Read-only flag of Selected INI File
        local LOCctrlEnableState = not (getFileAttribute DYNresourceMan.LOCiniFile #readOnly)
        DYNresourceMan.BMDYNdiffuse.enabled      = LOCctrlEnableState
        DYNresourceMan.BUDYNdiffuse.enabled      = LOCctrlEnableState
        DYNresourceMan.BMDYNopacity.enabled      = LOCctrlEnableState
        DYNresourceMan.BUDYNopacity.enabled      = LOCctrlEnableState
        DYNresourceMan.BUDYNopacityX.enabled     = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting01.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting02.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting03.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting04.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting05.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting06.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting07.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting08.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting09.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting10.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting11.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting12.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting13.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting14.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting15.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting16.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting17.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting18.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting19.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting20.enabled = LOCctrlEnableState
        DYNresourceMan.LBDYNiniSetting21.enabled = LOCctrlEnableState

        if not LOCctrlEnableState then DYNresourceMan.CBDYNxFall.enabled = false
        DYNresourceMan.SPDYNspinner01.enabled    = LOCctrlEnableState
        DYNresourceMan.SPDYNspinner02.enabled    = LOCctrlEnableState
        DYNresourceMan.SPDYNspinner03.enabled    = LOCctrlEnableState
        DYNresourceMan.SPDYNspinner04.enabled    = LOCctrlEnableState
        DYNresourceMan.SPDYNspinner05.enabled    = LOCctrlEnableState
        DYNresourceMan.SPDYNspinner06.enabled    = LOCctrlEnableState
        DYNresourceMan.SPDYNspinner07.enabled    = LOCctrlEnableState
        DYNresourceMan.SPDYNspinner08.enabled    = LOCctrlEnableState
        DYNresourceMan.BUDYNbutton01.enabled     = LOCctrlEnableState
        DYNresourceMan.BUDYNbutton02.enabled     = LOCctrlEnableState
        DYNresourceMan.BUDYNbutton03.enabled     = LOCctrlEnableState
        DYNresourceMan.BUDYNbutton04.enabled     = LOCctrlEnableState
        if LOCctrlEnableState == false then (messagebox (DYNuiResourcesErrorsWarnings[87]) title:DYNuiResourcesTitlebars[2])
      )
    )
    if not LOCfileFound then
    (
      DYNresourceMan.LBDYNiniSetting01.pos.x = 1555
      DYNresourceMan.LBDYNiniSetting02.pos.x = 1565 ; DYNresourceMan.SPDYNspinner01.pos = [1880,121]
      DYNresourceMan.LBDYNiniSetting03.pos.x = 1565 ; DYNresourceMan.SPDYNspinner02.pos = [1880,142]
      DYNresourceMan.LBDYNiniSetting04.pos.x = 1565 ; DYNresourceMan.SPDYNspinner03.pos = [1880,163]
      DYNresourceMan.LBDYNiniSetting05.pos.x = 1555 ; DYNresourceMan.SPDYNspinner04.pos = [1880,184]
      DYNresourceMan.LBDYNiniSetting06.pos.x = 1555 ; DYNresourceMan.SPDYNspinner05.pos = [1880,205]
      DYNresourceMan.LBDYNiniSetting07.pos.x = 1565 ; DYNresourceMan.BUDYNbutton01.pos  = [-810,226]
      DYNresourceMan.LBDYNiniSetting08.pos.x = 1565
      DYNresourceMan.LBDYNiniSetting09.pos.x = 1565 ; DYNresourceMan.BUDYNbutton02.pos  = [-810,269]
      DYNresourceMan.LBDYNiniSetting10.pos.x = 1555 ; DYNresourceMan.DDDYNdrop01.pos    = [-810,226]
      DYNresourceMan.LBDYNiniSetting11.pos.x = 1555 ; DYNresourceMan.CBDYNxFall.pos     = [2898,130]
      DYNresourceMan.LBDYNiniSetting12.pos.x = 1565 ; DYNresourceMan.BUDYNbutton03.pos  = [-810,332]
      DYNresourceMan.LBDYNiniSetting13.pos.x = 1555
      DYNresourceMan.LBDYNiniSetting14.pos.x = 1555
      DYNresourceMan.LBDYNiniSetting15.pos.x = 1565 ; DYNresourceMan.BUDYNbutton04.pos  = [1810,395]
      DYNresourceMan.LBDYNiniSetting16.pos.x = 1565 ; DYNresourceMan.SPDYNspinner06.pos = [1880,416]
      DYNresourceMan.LBDYNiniSetting17.pos.x = 1565 ; DYNresourceMan.SPDYNspinner07.pos = [1880,437]
      DYNresourceMan.LBDYNiniSetting18.pos.x = 1565 ; DYNresourceMan.SPDYNspinner08.pos = [1880,458]
      DYNresourceMan.BMDYNdiffuse.bitmap     = bitmap 196 151 color:LOCcol
      DYNresourceMan.BMDYNopacity.bitmap     = bitmap 196 151 color:LOCcol
      DYNresourceMan.BUDYNdiffuse.enabled    = false
      DYNresourceMan.BUDYNopacity.enabled    = false
      DYNresourceMan.BUDYNopacityX.enabled   = false
      DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNdiffuse1 DYNresourceMan.LBDYNdiffuse2 DYNresourceMan.LBDYNdiffuse3
      DYNresourceMan.DYNFUNdisplayBitmapAttribs "" DYNresourceMan.LBDYNopacity1 DYNresourceMan.LBDYNopacity2 DYNresourceMan.LBDYNopacity3
    )
  )

  fn DYNFUNchangeCategory FUNcategory FUNselectedFile =
  (
    local LOCiniPathTitle   = ""
    local LOCmapPathTitle   = ""
    local LOCrootObjectPath = ""
    if DYNresourceMan.LOCresourceKitMode == 1 then LOCrootObjectPath = DYNcountryPath
    if DYNresourceMan.LOCresourceKitMode == 2 then LOCrootObjectPath = rootNode.DYNrootNodeStore.string02
    if DYNresourceMan.LOCresourceKitMode == 3 then LOCrootObjectPath = DYNINIprivateKitPath

    DYNresourceMan.LBDYNiniFileList.text = DYNuiResourcesObjClasses[FUNcategory]

    --- vehicles
    if FUNcategory == 1 then
    (
      DYNresourceMan.LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameVehicles + DYNfolderSeperator
      DYNresourceMan.LOCmapPath = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameVehicles + DYNfolderSeperator
      DYNresourceMan.BUDYNdiffuse.text = DYNresourceMan.BUDYNbutton01.text = DYNuiResourcesButtons[110] ; DYNresourceMan.BUDYNdiffuse.enabled = true
      DYNresourceMan.BUDYNopacity.text = DYNresourceMan.BUDYNbutton02.text = DYNuiResourcesButtons[111] ; DYNresourceMan.BUDYNopacity.enabled = true
      DYNresourceMan.GBDYNdiffuse.text = DYNuiResourcesGroups[7]
      DYNresourceMan.GBDYNopacity.text = DYNuiResourcesGroups[134]
      LOCiniPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[493]
      LOCmapPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[495]
      DYNresourceMan.DDDYNdrop01.items  = #()
    )

    --- furniture
    if FUNcategory == 2 then
    (
      DYNresourceMan.LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameFurniture + DYNfolderSeperator
      DYNresourceMan.LOCmapPath = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameFurniture + DYNfolderSeperator
      DYNresourceMan.BUDYNdiffuse.text = DYNresourceMan.BUDYNbutton01.text = DYNuiResourcesButtons[110] ; DYNresourceMan.BUDYNdiffuse.enabled = true
      DYNresourceMan.BUDYNopacity.text = DYNresourceMan.BUDYNbutton02.text = DYNuiResourcesButtons[111] ; DYNresourceMan.BUDYNopacity.enabled = true
      DYNresourceMan.GBDYNdiffuse.text = DYNuiResourcesGroups[7]
      DYNresourceMan.GBDYNopacity.text = DYNuiResourcesGroups[134]
      LOCiniPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[493]
      LOCmapPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[495]
      DYNresourceMan.DDDYNdrop01.items  = #()
    )

    --- trees
    if FUNcategory == 3 then
    (
      DYNresourceMan.LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameTrees + DYNfolderSeperator
      DYNresourceMan.LOCmapPath = LOCrootObjectPath + DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameTreeMaps + DYNfolderSeperator
      DYNresourceMan.BUDYNdiffuse.text = DYNresourceMan.BUDYNbutton01.text = DYNuiResourcesButtons[114] ; DYNresourceMan.BUDYNdiffuse.enabled = true
      DYNresourceMan.BUDYNopacity.text = DYNresourceMan.BUDYNbutton02.text = DYNuiResourcesButtons[115] ; DYNresourceMan.BUDYNopacity.enabled = true
      DYNresourceMan.GBDYNdiffuse.text = DYNuiResourcesGroups[137]
      DYNresourceMan.GBDYNopacity.text = DYNuiResourcesGroups[138]
      LOCiniPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[493]
      LOCmapPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[494]
      DYNresourceMan.DDDYNdrop01.items  = #(DYNuiResourcesLabels[488], DYNuiResourcesLabels[489])
    )

    --- signs
    if FUNcategory == 4 then
    (
      DYNresourceMan.LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameSigns + DYNfolderSeperator
      DYNresourceMan.LOCmapPath = LOCrootObjectPath + DYNfolderNameMatLibs + DYNfolderSeperator + DYNfolderNameSignMaps + DYNfolderSeperator
      DYNresourceMan.BUDYNdiffuse.text = DYNresourceMan.BUDYNbutton01.text = DYNuiResourcesButtons[114] ; DYNresourceMan.BUDYNdiffuse.enabled = true
      DYNresourceMan.BUDYNopacity.text = DYNresourceMan.BUDYNbutton02.text = DYNuiResourcesButtons[115] ; DYNresourceMan.BUDYNopacity.enabled = true
      DYNresourceMan.GBDYNdiffuse.text = DYNuiResourcesGroups[137]
      DYNresourceMan.GBDYNopacity.text = DYNuiResourcesGroups[138]
      LOCiniPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[493]
      LOCmapPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[494]
      DYNresourceMan.DDDYNdrop01.items  = #(DYNuiResourcesLabels[490], DYNuiResourcesLabels[491], DYNuiResourcesLabels[492])

    )

    --- cameras
    if FUNcategory == 5 then
    (
      DYNresourceMan.LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNameCameras + DYNfolderSeperator
      DYNresourceMan.LOCmapPath = undefined
      DYNresourceMan.BUDYNdiffuse.text = DYNresourceMan.BUDYNbutton01.text = DYNuiResourcesButtons[113] ; DYNresourceMan.BUDYNdiffuse.enabled = true
      DYNresourceMan.BUDYNopacity.text = DYNresourceMan.BUDYNbutton02.text = ""                         ; DYNresourceMan.BUDYNopacity.enabled = false
      DYNresourceMan.GBDYNdiffuse.text = DYNuiResourcesGroups[136]
      DYNresourceMan.GBDYNopacity.text = ""
      LOCiniPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[493]
      LOCmapPathTitle = ""
      DYNresourceMan.DDDYNdrop01.items  = LOClensSizes
    )

    --- primitives
    if FUNcategory == 6 then
    (
      DYNresourceMan.LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + DYNfolderSeperator + DYNfolderNamePrimitives + DYNfolderSeperator
      DYNresourceMan.LOCmapPath = undefined
      DYNresourceMan.BUDYNdiffuse.text = DYNresourceMan.BUDYNbutton01.text = DYNuiResourcesButtons[112] ; DYNresourceMan.BUDYNdiffuse.enabled = true
      DYNresourceMan.BUDYNopacity.text = DYNresourceMan.BUDYNbutton02.text = DYNuiResourcesButtons[111] ; DYNresourceMan.BUDYNopacity.enabled = true
      DYNresourceMan.GBDYNdiffuse.text = DYNuiResourcesGroups[135]
      DYNresourceMan.GBDYNopacity.text = DYNuiResourcesGroups[134]
      LOCiniPathTitle = DYNuiResourcesObjClasses[FUNcategory] + ": " + DYNuiResourcesLabels[493]
      LOCmapPathTitle = ""
      DYNresourceMan.DDDYNdrop01.items  = DYNprimitiveTypes
    )

    --- Fill file list with all files in this object category
    local LOCfilesArray = DYNFUNiniGetBases FUNcategory DYNresourceMan.LOCresourceKitMode
    DYNFUNdisplayINIobjFileArrays FUNcategory DYNresourceMan DYNresourceMan.LOCresourceKitMode

    if FUNselectedFile != "" then
    (
      --- Select Required File from Current Folder (New TreeView Selection)
      local LOCitem = DYNresourceMan.DNDYNiniFileTree.nodes.find ("!" + (DYNFUNlowerCase FUNselectedFile) + ".ini") true
      if LOCitem.count > 0 then
      (
        DYNresourceMan.DNDYNiniFileTree.selectedNode = LOCitem[1]
        LOCitem[1].ensureVisible()
      )
    )
    else
    (
      --- Select Required File from Current Folder (New TreeView Selection)
      if LOCfilesArray.count > 0 then
      (
        local LOCitem = DYNresourceMan.DNDYNiniFileTree.nodes.find ("!" + (DYNFUNlowerCase ((sort LOCfilesArray)[1])) + ".ini") true
        if LOCitem.count > 0 then
        (
          DYNresourceMan.DNDYNiniFileTree.selectedNode = LOCitem[1]
          LOCitem[1].ensureVisible()
        )
      )
    )


    DYNresourceMan.DYNFUNselectINI()

    --- Display Current Object INI File Paths and Map Paths in Panel
    if DYNresourceMan.LOCiniPath != undefined then
    (
      DYNresourceMan.LBDYNiniPath.text = LOCiniPathTitle + ": " + (DYNFUNtrimPathName DYNresourceMan.LOCiniPath 425)
    )
    else
    (
      DYNresourceMan.LBDYNiniPath.text = LOCmapPathTitle + ": " + DYNuiResourcesLabels[120]
    )
    if DYNresourceMan.LOCmapPath != undefined then
    (
      DYNresourceMan.LBDYNmapPath.text = LOCmapPathTitle + ": " + (DYNFUNtrimPathName DYNresourceMan.LOCmapPath 425)
    )
    else
    (
      DYNresourceMan.LBDYNmapPath.text = ""
    )

    --- Update Text Labels in Panel and Set Focus
    DYNresourceMan.LBDYNcount.text = DYNFUNformatValueToString DYNuiResourcesLabels[487] LOCfilesArray.count
    setFocus DYNresourceMan.DNDYNiniFileTree

    --- Update Status Bar
    if DYNresourceMan.LOCresourceKitMode == 1 then DYNresourceMan.dnStatus.panels.item[3].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[56] DYNINIcountry
    if DYNresourceMan.LOCresourceKitMode == 2 then DYNresourceMan.dnStatus.panels.item[3].text = DYNuiResourcesStatusMessages[57]
    if DYNresourceMan.LOCresourceKitMode == 3 then DYNresourceMan.dnStatus.panels.item[3].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[58] sysInfo.userName
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label LBDYNiniFileList  pos:[98,14]   width:200
  label LBDYNcount        pos:[265,14]

  label LBDYNiniPath      pos:[331,28]  width:595
  label LBDYNmapPath      pos:[331,48]  width:595

  groupbox GBDYNdiffuse   pos:[326,72]  width:203 height:255
  bitmap BMDYNdiffuse     pos:[331,92]  width:193 height:151 align:#left
  button BUDYNdiffuse     pos:[331,249] width:193
  label LBDYNdiffuse1     pos:[331,276] width:193
  label LBDYNdiffuse2     pos:[331,292] width:193
  label LBDYNdiffuse3     pos:[331,308] width:193

  groupbox GBDYNopacity   pos:[326,333] width:203 height:255
  bitmap BMDYNopacity     pos:[331,355] width:193 height:151 align:#left
  button BUDYNopacity     pos:[331,512] width:173
  button BUDYNopacityX    pos:[504,512] width:20
  label LBDYNopacity1     pos:[331,539] width:193
  label LBDYNopacity2     pos:[331,555] width:193
  label LBDYNopacity3     pos:[331,571] width:193

  groupbox GBDYNgroup02   pos:[537,72]  width:387 height:516
  label LBDYNiniSetting01 pos:[555,100] width:240
  label LBDYNiniSetting02 pos:[555,121] width:240
  label LBDYNiniSetting03 pos:[555,142] width:240
  label LBDYNiniSetting04 pos:[555,163] width:240
  label LBDYNiniSetting05 pos:[555,184] width:240
  label LBDYNiniSetting06 pos:[555,205] width:240
  label LBDYNiniSetting07 pos:[555,226] width:240
  label LBDYNiniSetting08 pos:[555,247] width:240
  label LBDYNiniSetting09 pos:[555,268] width:240
  label LBDYNiniSetting10 pos:[555,289] width:240
  label LBDYNiniSetting11 pos:[555,310] width:240
  label LBDYNiniSetting12 pos:[555,331] width:240
  label LBDYNiniSetting13 pos:[555,352] width:240
  label LBDYNiniSetting14 pos:[555,373] width:240
  label LBDYNiniSetting15 pos:[555,394] width:240
  label LBDYNiniSetting16 pos:[555,415] width:240
  label LBDYNiniSetting17 pos:[555,436] width:240
  label LBDYNiniSetting18 pos:[555,457] width:240
  label LBDYNiniSetting19 pos:[555,478] width:240
  label LBDYNiniSetting20 pos:[555,499] width:240
  label LBDYNiniSetting21 pos:[555,520] width:240

  spinner SPDYNspinner01 "" fieldwidth:73 pos:[2880,100] scale:0.001 type:#worldunits
  spinner SPDYNspinner02 "" fieldwidth:73 pos:[2880,121] scale:0.001 type:#worldunits
  spinner SPDYNspinner03 "" fieldwidth:73 pos:[2880,142] scale:0.001 type:#worldunits
  spinner SPDYNspinner04 "" fieldwidth:73 pos:[2880,163] type:#integer
  spinner SPDYNspinner05 "" fieldwidth:73 pos:[2880,184] type:#integer
  spinner SPDYNspinner06 "" fieldwidth:73 pos:[2880,268] scale:0.001 type:#worldunits
  spinner SPDYNspinner07 "" fieldwidth:73 pos:[2880,289] scale:0.001 type:#worldunits
  spinner SPDYNspinner08 "" fieldwidth:73 pos:[2880,310] scale:0.001 type:#worldunits
  checkbutton CBDYNxFall  pos:[898,130]  width:16 height:17 highlightColor:DYNINIhighlightColor iconName:"Common/Lock"  iconSize:[16,16] enabled:false
  button  BUDYNbutton01   pos:[2810,205] width:82 height:18
  button  BUDYNbutton02   pos:[2810,226] width:82 height:18
  button  BUDYNbutton03   pos:[2810,247] width:82 height:18
  button  BUDYNbutton04   pos:[810,2331] width:82 height:18

  dropdownList DDDYNdrop01 "" pos:[810,450] width:83

  button BUDYNhelp        pos:[326,598] width:97
  button BUDYNfresh       pos:[426,598] width:97
  button BUDYNokok        pos:[828,598] width:97

  dotNetControl dnResourceKitList "System.Windows.Forms.ListView"   height:564 width:80  pos:[12,55]
  dotNetControl DNDYNiniFileTree  "System.Windows.Forms.TreeView"   height:564 width:214 pos:[98,55]
  dotNetControl dnTabCtrl         "System.Windows.Forms.TabControl" height:23  width:215 pos:[98,30]
  dotNetControl dnStatus          "System.Windows.Forms.StatusBar"  height:20  width:914 pos:[12,624]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNresourceMan open do
  (
    DYNresourceMan.title = DYNuiRolloutNames[60]

    GBDYNgroup02.text    = DYNuiResourcesGroups[139]

    BUDYNfresh.text      = DYNuiResourcesButtons[29]
    BUDYNokok.text       = DYNuiResourcesButtons[1]
    BUDYNhelp.text       = DYNuiResourcesButtons[5]
    BUDYNbutton03.text   = DYNuiResourcesButtons[108]
    BUDYNbutton04.text   = DYNuiResourcesButtons[109]
    BUDYNopacityX.text   = DYNuiResourcesButtons[22]

    LOCresourceKitMode   = 1

    LOClensSizes[DYNlensSizes.count] = undefined
    for i = 1 to LOClensSizes.count do LOClensSizes[i] = (DYNlensSizes[i] as string) + "mm"

    LOCallowDnSelection  = false
    DYNFUNresourceKitListViewStyleAndContent DYNiconsPath LOCresourceKitMode false dnResourceKitList
    LOCallowDnSelection  = true

    DYNFUNdnTreeViewStyle DNDYNiniFileTree
    DNDYNiniFileTree.imageList = DYNdnSmImageList

    dntabCtrl.ImageList = DYNdnSmImageList
    dntabCtrl.padding.x = 2

    for i = 1 to 6 do
    (
      dntabCtrl.tabpages.add ""
      dntabCtrl.tabpages.item[i-1].imageIndex = i
    )

    dntabCtrl.multiLine = false
    dntabCtrl.SizeMode  = (dotNetClass "System.Windows.Forms.TabSizeMode").fillToRight

    --- Update Status Panel
    dnStatus.showPanels    = true
    dnStatus.SizingGrip    = false
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.item[0].width     = 200
    dnStatus.panels.item[0].alignment = DYNdnHorAlignClass.Center

    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.item[1].width     = 220
    dnStatus.panels.item[1].alignment = DYNdnHorAlignClass.Center

    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.item[2].Width     = 220
    dnStatus.panels.item[2].alignment = DYNdnHorAlignClass.Center

    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.item[3].autosize = (dotNetClass "System.Windows.Forms.StatusBarPanelAutoSize").spring
    dnStatus.panels.item[3].alignment = DYNdnHorAlignClass.Center

    --- Display INI Files
    DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
    gc()
  )

  on DYNresourceMan close do
  (
    DYNFUNonDialogClose()
    LOClensSizes = #()

    if DYNresourceList != undefined then
    (
      if DYNresourceList.open then
      (
        DYNresourceList.DYNFUNpopulateResourceList DYNresourceList.LOCobjectSwitch undefined DYNresourceList.LOCresourceType DYNresourceList.LOCresourceKitMode
      )
    )

    if DYNobjectPlacer != undefined then
    (
      if DYNobjectPlacer.open and DYNobjectPlacer.LOCselStyleElem != 0 then
      (
        DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
        DYNobjectPlacer.DYNFUNupdateElementList DYNobjectPlacer.LOCselStyleElem 1 true LOCresourceKitMode
      )
      freeSceneBitmaps()
    )
  )

  on DYNresourceMan moved argPt2 do
  (
    DYNresLUP = argPt2
  )

  on BUDYNdiffuse pressed do
  (
    local LOCcat = dntabCtrl.selectedTab.TabIndex + 1
    if LOCcat == 1 or LOCcat == 2 then (DYNFUNchangeSourceFile LOCiniPath)
    if LOCcat == 3 or LOCcat == 4 then (DYNFUNchangeDiffuse LOCmapPath)
    if LOCcat == 5 then
    (
      local LOCselect = try ((DYNFUNiniGetValue LOCiniFile "Parameters" "Lens" LOCresourceKitMode) as integer) catch (1)
      if LOCselect > 0 and LOCselect <= LOClensSizes.count then
      (
        local LOCnewSelect = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[52] "Lens Size" LOClensSizes LOCselect
        if LOCnewSelect != LOCselect then (LBDYNiniSetting02.text = "Lens = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Lens" LOCnewSelect))
      )
    )
    if LOCcat == 6 then
    (
      local LOCselect = findItem DYNprimitiveTypes ((DYNFUNobjectINIparams (getFilenameFile LOCiniFile) 6 DYNresourceMan.LOCresourceKitMode)[8])
      if LOCselect > 0 and LOCselect <= DYNprimitiveTypes.count then
      (
        local LOCnewSelect = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[53] "Primitive Type" DYNprimitiveTypes LOCselect
        if LOCnewSelect != LOCselect then (LBDYNiniSetting07.text = "Primitive = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Object" "Primitive" DYNprimitiveTypes[LOCnewSelect]))
      )
    )
  )

  on BUDYNbutton01 pressed do
  (
    local LOCcat = dntabCtrl.selectedTab.TabIndex + 1
    if LOCcat == 1 or LOCcat == 2 then (DYNFUNchangeSourceFile LOCiniPath)
    if LOCcat == 3 or LOCcat == 4 then (DYNFUNchangeDiffuse LOCmapPath)
  )

  on DDDYNdrop01 selected arg do
  (
    local LOCcat = dntabCtrl.selectedTab.TabIndex + 1
    if LOCcat == 3 then LBDYNiniSetting10.text = "Style = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Tree Defaults" "Style" arg)
    if LOCcat == 4 then LBDYNiniSetting10.text = "Style = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Sign Defaults" "Style" arg)
    if LOCcat == 5 then LBDYNiniSetting02.text = "Lens = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Lens" arg)
    if LOCcat == 6 then LBDYNiniSetting07.text = "Primitive = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Object" "Primitive" DYNprimitiveTypes[arg])
  )

  on BUDYNopacity pressed do
  (
    local LOCcat = dntabCtrl.selectedTab.TabIndex + 1
    if LOCcat == 1 or LOCcat == 2 or LOCcat == 6 then (DYNFUNchangePreview LOCresourceKitMode)
    if LOCcat == 3 or LOCcat == 4 then (DYNFUNchangeOpacity LOCmapPath)
  )

  on BUDYNopacityX pressed do
  (
    local LOCcat = dntabCtrl.selectedTab.TabIndex + 1
    if LOCcat == 1 or LOCcat == 2 or LOCcat == 6 then
    (
      if (queryBox (DYNuiResourcesQueries[74]) title:DYNuiResourcesTitlebars[2] beep:false) then
      (
        DYNresourceMan.BMDYNopacity.bitmap =  bitmap 196 151 color:(color 190 190 190)
        DYNresourceMan.LBDYNiniSetting09.text = "Preview = " + (DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Object" "Preview" "")
      )
    )
    if LOCcat == 3 or LOCcat == 4 then
    (
      if (queryBox (DYNuiResourcesQueries[75]) title:DYNuiResourcesTitlebars[2] beep:false) then
      (
        DYNresourceMan.BMDYNopacity.bitmap =  bitmap 196 151 color:(color 190 190 190)
        DYNresourceMan.LBDYNiniSetting07.text = "Opacity = " + DYNresourceMan.DYNFUNsetAndVerifyINIvalue LOCiniFile "Maps" "Opacity" ""
      )
    )
  )

  on BUDYNbutton02 pressed do
  (
    local LOCcat = dntabCtrl.selectedTab.TabIndex + 1
    if LOCcat == 1 or LOCcat == 2 or LOCcat == 6 then (DYNFUNchangePreview LOCresourceKitMode)
    if LOCcat == 3 or LOCcat == 4 then (DYNFUNchangeOpacity LOCmapPath)
  )

  on BUDYNbutton03 pressed do
  (
    local LOCcat = dntabCtrl.selectedTab.TabIndex + 1

    --- Get New Group Name (will return undefined if cancel button is picked)
    local LOCnewGroup = DYNFUNdisplayEditText DYNuiResourcesTitlebars[47] DYNuiResourcesLabels[486] (DYNFUNiniGetValue LOCiniFile "Group" "Name" LOCresourceKitMode)

    --- If Cancel was not pressed, update INI file and panel with new group name
    if LOCnewGroup != undefined then
    (
      if LOCcat == 1 then LBDYNiniSetting12.text = "Name = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Group" "Name" LOCnewGroup)
      if LOCcat == 2 then LBDYNiniSetting15.text = "Name = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Group" "Name" LOCnewGroup)
      if LOCcat == 3 then LBDYNiniSetting13.text = "Name = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Group" "Name" LOCnewGroup)
      if LOCcat == 4 then LBDYNiniSetting15.text = "Name = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Group" "Name" LOCnewGroup)
      if LOCcat == 5 then LBDYNiniSetting08.text = "Name = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Group" "Name" LOCnewGroup)
      if LOCcat == 6 then LBDYNiniSetting12.text = "Name = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Group" "Name" LOCnewGroup)
    )
    DYNFUNchangeCategory (dntabCtrl.selectedTab.TabIndex + 1) DYNresourceMan.DNDYNiniFileTree.selectedNode.text
  )

  on dnTabCtrl mouseUp arg do
  (
    DYNFUNchangeCategory (dnTabCtrl.selectedTab.TabIndex + 1) ""
  )

  on dnResourceKitList ItemSelectionChanged arg do
  (
    if arg.isSelected and LOCallowDnSelection then
    (
      LOCresourceKitMode = arg.item.imageIndex
      DYNFUNchangeCategory (dntabCtrl.selectedTab.TabIndex + 1) ""
    )
  )

  on DNDYNiniFileTree MouseDown arg do
  (
    local LOCnode = DNDYNiniFileTree.getNodeAt arg.x arg.y
    if LOCnode != undefined then DNDYNiniFileTree.selectedNode = LOCnode
    DYNFUNselectINI()
  )

  on DNDYNiniFileTree KeyUp arg do
  (
    if DNDYNiniFileTree.selectedNode != undefined then DYNFUNselectINI()
  )

  on DNDYNiniFileTree MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNobjectMenu()
      if LOCobjectMenu != undefined then popupMenu LOCobjectMenu
    )
  )

  on SPDYNspinner01 changed arg do
  (
    --- Lock Aspect Ratio for Signs
    if CBDYNxFall.checked and (dntabCtrl.selectedTab.TabIndex + 1) == 3 and LOCaspectRatio > 0.0 then (SPDYNspinner02.value = arg / LOCaspectRatio)-- Trees
    if CBDYNxFall.checked and (dntabCtrl.selectedTab.TabIndex + 1) == 4 and LOCaspectRatio > 0.0 then (SPDYNspinner02.value = arg / LOCaspectRatio)-- Signs
  )

  on SPDYNspinner02 changed arg do
  (
    --- Lock Aspect Ratio for Signs
    if CBDYNxFall.checked and (dntabCtrl.selectedTab.TabIndex + 1) == 3 and LOCaspectRatio > 0.0 then (SPDYNspinner01.value = arg * LOCaspectRatio)-- Trees
    if CBDYNxFall.checked and (dntabCtrl.selectedTab.TabIndex + 1) == 4 and LOCaspectRatio > 0.0 then (SPDYNspinner01.value = arg * LOCaspectRatio)-- Signs
  )

  on CBDYNxFall changed arg do
  (
    if arg and LOCaspectRatio > 0.0 and ((dntabCtrl.selectedTab.TabIndex + 1) == 3 or (dntabCtrl.selectedTab.TabIndex + 1) == 4) then
    (
      --- First, get diffuse map, and reset aspect ratio to bitmap dims
      local LOCdiff = (DYNFUNobjectINIparams (getFilenameFile DYNresourceMan.LOCiniFile) (dntabCtrl.selectedTab.TabIndex + 1) LOCresourceKitMode)[7]
      local LOCmatDiffuse = try (openBitmap LOCdiff) catch ()
      if LOCmatDiffuse != undefined then
      (
        LOCaspectRatio = try ((LOCmatDiffuse.width  / 100.0) / (LOCmatDiffuse.height / 100.0)) catch (0.0)
      )

      --- Update Panel
      SPDYNspinner02.value   = SPDYNspinner01.value / LOCaspectRatio
      LBDYNiniSetting03.text = "Height = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Height" SPDYNspinner02.value)  -- Lock Aspect Ratio for Signs/Trees
    )
  )

  on SPDYNspinner01 entered do
  (
    local LOCcat = (dntabCtrl.selectedTab.TabIndex + 1)
    if LOCcat == 3 or LOCcat == 4 then
    (
      LBDYNiniSetting02.text = "Width = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Width" SPDYNspinner01.value)
      if CBDYNxFall.checked and LOCaspectRatio > 0.0 then (LBDYNiniSetting03.text = "Height = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Height" SPDYNspinner02.value)) -- Lock Aspect Ratio for Signs/Trees
    )
    if LOCcat == 1 or LOCcat == 2 or LOCcat == 6 then (LBDYNiniSetting02.text = "Length = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Length" SPDYNspinner01.value))
    if LOCcat == 5 then (LBDYNiniSetting03.text = "EnvironmentNear = "  + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "EnvironmentNear" SPDYNspinner01.value))
  )

  on SPDYNspinner02 entered do
  (
    local LOCcat = (dntabCtrl.selectedTab.TabIndex + 1)
    if LOCcat == 3 or LOCcat == 4 then
    (
      LBDYNiniSetting03.text = "Height = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Height" SPDYNspinner02.value)
      if CBDYNxFall.checked and LOCaspectRatio > 0.0 then (LBDYNiniSetting02.text = "Width = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Width" SPDYNspinner01.value)) -- Lock Aspect Ratio for Signs/Trees
    )
    if LOCcat == 1 or LOCcat == 2 or LOCcat == 6 then (LBDYNiniSetting03.text = "Width = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Width" SPDYNspinner02.value))
    if LOCcat == 5 then (LBDYNiniSetting04.text = "EnvironmentFar = "  + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "EnvironmentFar" SPDYNspinner02.value))
  )

  on SPDYNspinner03 entered do
  (
    local LOCcat = (dntabCtrl.selectedTab.TabIndex + 1)
    if LOCcat == 1 or LOCcat == 2 or LOCcat == 6 then (LBDYNiniSetting04.text = "Height = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters" "Height" SPDYNspinner03.value))
    if LOCcat == 4 then (LBDYNiniSetting12.text = "GroundClearance = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Sign Defaults" "GroundClearance" SPDYNspinner03.value))
  )

  on SPDYNspinner04 entered do
  (
    local LOCcat = (dntabCtrl.selectedTab.TabIndex + 1)
    if LOCcat == 6 then (LBDYNiniSetting08.text = "MaterialChannel = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Object"        "MaterialChannel" SPDYNspinner04.value))
  )

  on SPDYNspinner05 entered do
  (
    local LOCcat = (dntabCtrl.selectedTab.TabIndex + 1)
    if LOCcat == 2 then (LBDYNiniSetting12.text = "DefaultInterval = " + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Placement"     "DefaultInterval" SPDYNspinner05.value))
    if LOCcat == 4 then (LBDYNiniSetting11.text = "Posts = "           + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Sign Defaults" "Posts"           SPDYNspinner05.value))
    if LOCcat == 5 then (LBDYNiniSetting05.text = "TargetLength = "    + (DYNFUNsetAndVerifyINIvalue LOCiniFile "Parameters"    "TargetLength"    SPDYNspinner05.value))
  )

  on BUDYNfresh pressed do
  (
    DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
    DYNFUNchangeCategory (dntabCtrl.selectedTab.TabIndex + 1) (getFilenameFile LOCiniFile)
  )

  on BUDYNokok pressed do
  (
    destroyDialog DYNresourceMan
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13208 -- id_cv_resource_kit_manager
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCOiZeSHXuWFDYTrTxk1VmTI9Pg2nYqWu/N
-- JCDmpjQjr1LYb0df/KlTj0nUrShcjvfP0LZv304PdEadZ5IxXaUGtPLF6Z6M1pVC
-- GpNwA5DX9lnGsB1v1qCJGfDkjc7jxH7c7yF1o/dIVsPu19eCpIIcLhwIZBYz4rgH
-- Ch6gA5ARnSSPwP1RZJ7TUexOchvZrqPoLMegLWBl+9zrHtc8rW0yBNYBe6qQOCZl
-- l5GgNw/5XokcQ/UcNv+O/WMHRYQS5LWNtdn+FoKLVvSmLwjA+WmoJsggXQqZbnAc
-- txDwrjLjqVhkTnXs0XXyBIS8nPjUstouCPBx+bKSqnIQQ9C5GPF0
-- -----END-SIGNATURE-----